/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.context;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.MacroRequiredRight;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightReporter;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightsAnalyzer;
import org.xwiki.properties.BeanManager;
import org.xwiki.properties.PropertyException;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.context.ContextMacroParameters;

@Component
@Named(value="context")
@Singleton
public class ContextMacroRequiredRightsAnalyzer
implements MacroRequiredRightsAnalyzer {
    @Inject
    private BeanManager beanManager;

    public void analyze(MacroBlock macroBlock, MacroRequiredRightReporter reporter) {
        ContextMacroParameters parameters = new ContextMacroParameters();
        try {
            this.beanManager.populate((Object)parameters, macroBlock.getParameters());
            if (parameters.getSource() != null) {
                String sourceType;
                switch (sourceType = parameters.getSource().getType()) {
                    case "string": {
                        if (parameters.isRestricted()) break;
                        reporter.analyzeContent(macroBlock, parameters.getSource().getReference());
                        break;
                    }
                    case "script": {
                        if (parameters.isRestricted()) {
                            reporter.report(macroBlock, List.of(MacroRequiredRight.SCRIPT), "rendering.macro.context.requiredRights.restrictedScriptSource", new Object[0]);
                            break;
                        }
                        reporter.report(macroBlock, List.of(MacroRequiredRight.SCRIPT, MacroRequiredRight.MAYBE_PROGRAM), "rendering.macro.context.requiredRights.arbitraryScriptSource", new Object[0]);
                        break;
                    }
                }
            } else if (!parameters.isRestricted()) {
                reporter.analyzeContent(macroBlock, macroBlock.getContent());
            }
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }
}

