/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.context;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.context.ContextMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component(roles={ContextMacroDocument.class})
@Singleton
public class ContextMacroDocument {
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @Named(value="macro")
    private DocumentReferenceResolver<String> macroReferenceResolver;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public DocumentReference getDocumentReference(ContextMacroParameters parameters, MacroTransformationContext context) throws MacroExecutionException {
        DocumentReference referencedDocReference;
        if (parameters.getDocument() != null) {
            referencedDocReference = this.macroReferenceResolver.resolve((Object)parameters.getDocument(), new Object[]{context.getCurrentMacroBlock()});
            DocumentReference currentAuthor = this.documentAccessBridge.getCurrentAuthorReference();
            this.checkAccess(currentAuthor, referencedDocReference);
        } else {
            referencedDocReference = null;
        }
        return referencedDocReference;
    }

    private void checkAccess(DocumentReference currentAuthor, DocumentReference referencedDocReference) throws MacroExecutionException {
        try {
            this.authorizationManager.checkAccess(Right.VIEW, currentAuthor, (EntityReference)referencedDocReference);
        }
        catch (AccessDeniedException e) {
            throw new MacroExecutionException("Author [" + String.valueOf(currentAuthor) + "] is not allowed to access target document [" + String.valueOf(referencedDocReference) + "]", (Throwable)e);
        }
    }
}

