/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.code.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.macro.code.source.EntityCodeMacroSourceLoader;
import org.xwiki.rendering.internal.macro.code.source.MacroCodeEntitySoureConfiguration;
import org.xwiki.rendering.internal.parser.pygments.PygmentsUtils;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.code.source.CodeMacroSource;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;

@Component(hints={"ATTACHMENT", "PAGE_ATTACHMENT"})
@Singleton
public class DocumentAttachmentCodeMacroSourceLoader
implements EntityCodeMacroSourceLoader {
    @Inject
    private MacroCodeEntitySoureConfiguration configuration;

    @Override
    public CodeMacroSource load(XWikiDocument document, EntityReference entityReference, MacroContentSourceReference reference, XWikiContext xcontext) throws MacroExecutionException {
        String content;
        long attachmentSize;
        XWikiAttachment attachment = document.getAttachment(entityReference.getName());
        if (attachment == null) {
            throw new MacroExecutionException("Unknown attachment [" + String.valueOf(entityReference) + "]");
        }
        try {
            attachmentSize = attachment.getContentLongSize(xcontext);
        }
        catch (XWikiException e) {
            throw new MacroExecutionException("Failed to get the size of attachment [" + String.valueOf(entityReference) + "]", (Throwable)e);
        }
        if (attachmentSize > (long)this.configuration.getMaximumAttachmentSize()) {
            throw new MacroExecutionException("The size of the attachment [" + String.valueOf(entityReference) + "] is too big ([" + attachmentSize + "]) for the maximum [" + this.configuration.getMaximumAttachmentSize() + "]");
        }
        try (InputStream stream = attachment.getContentInputStream(xcontext);){
            content = attachment.getCharset() != null ? IOUtils.toString((InputStream)stream, (String)attachment.getCharset()) : IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to read content of attachment [" + String.valueOf(entityReference) + "]", (Throwable)e);
        }
        return new CodeMacroSource(reference, content, PygmentsUtils.mimetypeToLanguage((String)attachment.getMimeType()));
    }
}

