/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.code.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.internal.macro.code.source.EntityCodeMacroSourceLoader;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.code.source.CodeMacroSource;
import org.xwiki.rendering.macro.code.source.CodeMacroSourceFactory;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractEntityCodeMacroSourceFactory
implements CodeMacroSourceFactory {
    @Inject
    @Named(value="macro")
    private EntityReferenceResolver<String> resolver;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private ComponentManager componentManager;

    public CodeMacroSource getContent(MacroContentSourceReference reference, MacroTransformationContext context) throws MacroExecutionException {
        XWikiDocument document;
        EntityReference entityReference = this.resolver.resolve((Object)reference.getReference(), this.getEntityType(), new Object[]{context.getCurrentMacroBlock()});
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext == null) {
            throw new MacroExecutionException("No XWiki context could be found in the current context");
        }
        DocumentReference documentReference = xcontext.getWiki().getDocumentReference(entityReference, xcontext);
        try {
            this.authorization.checkAccess(Right.VIEW, xcontext.getAuthorReference(), (EntityReference)documentReference);
        }
        catch (AccessDeniedException e) {
            throw new MacroExecutionException("Current author is not allowed to access document [" + String.valueOf(documentReference) + "]", (Throwable)e);
        }
        if (!this.authorization.hasAccess(Right.VIEW, xcontext.getUserReference(), (EntityReference)documentReference)) {
            throw new MacroExecutionException("Current user is not allowed to access document [" + String.valueOf(documentReference) + "]");
        }
        try {
            document = xcontext.getWiki().getDocument(documentReference, xcontext);
        }
        catch (XWikiException e) {
            throw new MacroExecutionException("Failed to load document [" + String.valueOf(documentReference) + "]", (Throwable)e);
        }
        if (document.isNew()) {
            throw new MacroExecutionException("Entity [" + String.valueOf(reference) + "] does not exist");
        }
        if (documentReference.getLocale() == null) {
            try {
                document = document.getTranslatedDocument(xcontext);
            }
            catch (XWikiException e) {
                throw new MacroExecutionException("Failed to load document translation for reference [" + String.valueOf(documentReference) + "]", (Throwable)e);
            }
        }
        return this.getContent(document, entityReference, reference, xcontext);
    }

    protected abstract EntityType getEntityType();

    private CodeMacroSource getContent(XWikiDocument document, EntityReference entityReference, MacroContentSourceReference reference, XWikiContext xcontext) throws MacroExecutionException {
        EntityCodeMacroSourceLoader loader;
        if (!this.componentManager.hasComponent(EntityCodeMacroSourceLoader.class, entityReference.getType().name())) {
            throw new MacroExecutionException("Unsupported entity type [" + String.valueOf(entityReference.getType()) + "] for reference [" + String.valueOf(entityReference) + "]");
        }
        try {
            loader = (EntityCodeMacroSourceLoader)this.componentManager.getInstance(EntityCodeMacroSourceLoader.class, entityReference.getType().name());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Unexpected error when initializing the content loader for entity type [" + String.valueOf(entityReference.getType()) + "]", (Throwable)e);
        }
        return loader.load(document, entityReference, reference, xcontext);
    }
}

