/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.pygments;

import java.util.Map;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

public final class PygmentsUtils {
    private static final String LANGUAGE_HTML = "html";
    private static final String LANGUAGE_XML = "xml";
    private static final Map<SyntaxType, String> SYNTAX_TYPE_MAPPING = Map.of(SyntaxType.ANNOTATED_HTML, "html", SyntaxType.ANNOTATED_XHTML, "html", SyntaxType.HTML, "html", SyntaxType.XHTML, "html", SyntaxType.CONFLUENCEXHTML, "html");
    private static final Map<String, String> MIME_MAPPING = Map.of("text/html", "html", "application/xhtml+xml", "html", "text/javascript", "javascript", "application/json", "json", "application/ld+json", "jsonld", "application/x-httpd-php", "php", "application/xml", "xml", "text/xml", "xml", "application/atom+xml", "xml", "text/css", "css");

    private PygmentsUtils() {
    }

    public static String syntaxToLanguage(Syntax syntax) {
        return syntax != null ? SYNTAX_TYPE_MAPPING.get(syntax.getType()) : null;
    }

    public static String mimetypeToLanguage(String mimetype) {
        return mimetype != null ? MIME_MAPPING.get(mimetype) : null;
    }
}

