/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.pygments;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.python.core.PyNone;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.internal.parser.pygments.PygmentsListener;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;

public class BlocksGeneratorPygmentsListener
implements PygmentsListener {
    private List<Block> blocks = new ArrayList<Block>();
    private Parser plainTextParser;

    public BlocksGeneratorPygmentsListener(Parser plainTextParser) {
        this.plainTextParser = plainTextParser;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    public void format(String tokenType, String value, Map<String, Object> style) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            List blockList;
            try {
                blockList = ((Block)this.plainTextParser.parse((Reader)new StringReader(value)).getChildren().get(0)).getChildren();
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse [" + value + "] as plain text.", e);
            }
            String styleParameter = this.formatStyle(style);
            if (styleParameter.length() > 0) {
                FormatBlock formatBlock = new FormatBlock(blockList, Format.NONE);
                formatBlock.setParameter("style", styleParameter);
                this.blocks.add((Block)formatBlock);
            } else {
                this.blocks.addAll(blockList);
            }
        }
    }

    protected String formatStyle(Map<String, Object> style) {
        StringBuffer styleOut = new StringBuffer();
        this.appendBold(styleOut, style);
        this.appendItalic(styleOut, style);
        this.appendUnderline(styleOut, style);
        this.appendColor(styleOut, style);
        this.appendBgColor(styleOut, style);
        this.appendBorder(styleOut, style);
        return styleOut.toString();
    }

    protected void appendBold(StringBuffer styleOut, Map<String, Object> styles) {
        this.appendBoolean(styleOut, "bold", "font-weight: bold; ", styles);
    }

    protected void appendItalic(StringBuffer styleOut, Map<String, Object> styles) {
        this.appendBoolean(styleOut, "italic", "font-style: italic; ", styles);
    }

    protected void appendUnderline(StringBuffer styleOut, Map<String, Object> styles) {
        this.appendBoolean(styleOut, "underline", "text-decoration: underline; ", styles);
    }

    protected void appendColor(StringBuffer styleOut, Map<String, Object> styles) {
        this.appendStringValue(styleOut, "color", "color: #{0}; ", styles);
    }

    protected void appendBgColor(StringBuffer styleOut, Map<String, Object> styles) {
        this.appendStringValue(styleOut, "bgcolor", "background-color: #{0}; ", styles);
    }

    protected void appendBorder(StringBuffer styleOut, Map<String, Object> styles) {
        this.appendStringValue(styleOut, "border", "border: 1px solid #{0}; ", styles);
    }

    private void appendStringValue(StringBuffer styleOut, String pyName, String cssPattern, Map<String, Object> styles) {
        Object obj = styles.get(pyName);
        if (obj != null && !(obj instanceof PyNone)) {
            styleOut.append(MessageFormat.format(cssPattern, obj));
        }
    }

    private void appendBoolean(StringBuffer styleOut, String pyName, String cssValue, Map<String, Object> styles) {
        Object obj = styles.get(pyName);
        if (obj != null && !(obj instanceof PyNone) && ((Boolean)obj).booleanValue()) {
            styleOut.append(cssValue);
        }
    }
}

