/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.code.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.internal.code.layout.CodeLayoutHandler;

@Component
@Singleton
@Named(value="linenumbers")
public class LineNumberBlockHandler
implements CodeLayoutHandler {
    private Pattern linePattern = Pattern.compile("\r?\n");

    @Override
    public List<Block> layout(List<Block> blocks, String originalContent) {
        Matcher matcher = this.linePattern.matcher(originalContent);
        int lineCount = 1;
        while (matcher.find()) {
            ++lineCount;
        }
        ArrayList<Object> lineBlocks = new ArrayList<Object>(lineCount * 2);
        for (int i = 0; i < lineCount; ++i) {
            lineBlocks.add(new WordBlock(Integer.toString(i + 1)));
            lineBlocks.add(new NewLineBlock());
        }
        GroupBlock lineNumbers = new GroupBlock(lineBlocks);
        this.setClassParameter((Block)lineNumbers, "linenos");
        GroupBlock codeBlocks = new GroupBlock(blocks);
        GroupBlock wrapper = new GroupBlock(Arrays.asList(lineNumbers, codeBlocks));
        this.setClassParameter((Block)wrapper, "linenoswrapper");
        return Arrays.asList(wrapper);
    }

    private void setClassParameter(Block block, String value) {
        block.setParameter("class", value);
    }
}

