/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.configuration.migrations;

import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="R140100000XRENDERING375DataMigration")
@Singleton
public class R140100000XRENDERING375DataMigration
extends AbstractHibernateDataMigration {
    private static final String DISABLED_SYNTAXES_PROPERTY = "disabledSyntaxes";
    @Inject
    @Named(value="rendering")
    private ConfigurationSource renderingConfiguration;

    public String getDescription() {
        return "Disable the new XHTML 5 and HTML 5.0 syntax such that they are disabled by default.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(140100000);
    }

    protected void hibernateMigrate() throws DataMigrationException {
        List disabledSyntaxesAsStrings = (List)this.renderingConfiguration.getProperty(DISABLED_SYNTAXES_PROPERTY);
        if (disabledSyntaxesAsStrings != null && !disabledSyntaxesAsStrings.isEmpty()) {
            ArrayList<String> extendedDisabledSyntaxes = new ArrayList<String>(disabledSyntaxesAsStrings);
            for (Syntax syntaxToDisable : List.of(Syntax.HTML_5_0, Syntax.XHTML_5)) {
                String idString = syntaxToDisable.toIdString();
                if (extendedDisabledSyntaxes.contains(idString)) continue;
                extendedDisabledSyntaxes.add(idString);
            }
            if (!extendedDisabledSyntaxes.equals(disabledSyntaxesAsStrings)) {
                try {
                    this.renderingConfiguration.setProperties(Map.of(DISABLED_SYNTAXES_PROPERTY, extendedDisabledSyntaxes));
                }
                catch (ConfigurationSaveException e) {
                    throw new DataMigrationException("Error disabling HTML 5.0 and XHTML 5", (Throwable)e);
                }
            }
        }
    }
}

