/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.configuration;

import com.xpn.xwiki.CoreConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.configuration.ExtendedRenderingConfiguration;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;

@Component
@Singleton
public class DefaultExtendedRenderingConfiguration
implements ExtendedRenderingConfiguration {
    private static final String PREFIX = "rendering.";
    private static final String DISABLED_SYNTAXES_PROPERTY = "disabledSyntaxes";
    @Inject
    private ConfigurationSource configuration;
    @Inject
    @Named(value="rendering")
    private ConfigurationSource renderingConfiguration;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiCfgConfiguration;
    @Inject
    private CoreConfiguration coreConfiguration;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private SyntaxRegistry syntaxRegistry;

    public int getImageWidthLimit() {
        return (Integer)this.configuration.getProperty("rendering.imageWidthLimit", (Object)-1);
    }

    public int getImageHeightLimit() {
        return (Integer)this.configuration.getProperty("rendering.imageHeightLimit", (Object)-1);
    }

    public boolean isImageDimensionsIncludedInImageURL() {
        return (Boolean)this.configuration.getProperty("rendering.imageDimensionsIncludedInImageURL", (Object)true);
    }

    public List<Syntax> getDisabledSyntaxes() {
        ArrayList<Syntax> disabledSyntaxes = new ArrayList<Syntax>();
        List disabledSyntaxesAsStrings = (List)this.renderingConfiguration.getProperty(DISABLED_SYNTAXES_PROPERTY);
        if (disabledSyntaxesAsStrings == null) {
            List<Syntax> configuredSyntaxes = this.convertList((List)this.xwikiCfgConfiguration.getProperty("xwiki.rendering.syntaxes", List.class));
            if (configuredSyntaxes == null || configuredSyntaxes.isEmpty()) {
                disabledSyntaxes.addAll(this.computeDisabledSyntaxes(Collections.singletonList(this.getDefaultContentSyntax())));
            } else {
                disabledSyntaxes.addAll(this.computeDisabledSyntaxes(configuredSyntaxes));
            }
        } else {
            disabledSyntaxes.addAll(this.convertList(disabledSyntaxesAsStrings));
        }
        return disabledSyntaxes;
    }

    public List<Syntax> getConfiguredSyntaxes() {
        ArrayList<Syntax> configuredSyntaxes = new ArrayList<Syntax>();
        List<Syntax> disabledSyntaxes = this.getDisabledSyntaxes();
        for (Syntax availablesyntax : this.getAvailableParserSyntaxes()) {
            if (disabledSyntaxes.contains(availablesyntax)) continue;
            configuredSyntaxes.add(availablesyntax);
        }
        return configuredSyntaxes;
    }

    public Syntax getDefaultContentSyntax() {
        return this.coreConfiguration.getDefaultDocumentSyntax();
    }

    private List<Syntax> convertList(List<String> syntaxesAsStrings) {
        if (syntaxesAsStrings == null) {
            return null;
        }
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        for (String syntaxAsString : syntaxesAsStrings) {
            try {
                syntaxes.add(this.syntaxRegistry.resolveSyntax(syntaxAsString));
            }
            catch (ParseException e) {
                throw new RuntimeException(String.format("Failed to convert [%s] into Syntax object", syntaxAsString), e);
            }
        }
        return syntaxes;
    }

    private List<Syntax> computeDisabledSyntaxes(List<Syntax> configuredSyntaxes) {
        ArrayList<Syntax> disabledSyntaxes = new ArrayList<Syntax>();
        for (Syntax availableSyntax : this.getAvailableParserSyntaxes()) {
            if (configuredSyntaxes.contains(availableSyntax)) continue;
            disabledSyntaxes.add(availableSyntax);
        }
        return disabledSyntaxes;
    }

    public List<Syntax> getAvailableParserSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (Parser parser : ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(Parser.class)) {
                syntaxes.add(parser.getSyntax());
            }
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to lookup parsers", e);
        }
        return syntaxes;
    }
}

