/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.AsyncMacroParameters;
import org.xwiki.rendering.async.internal.AbstractExecutedContentMacro;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="async")
@Singleton
public class AsyncMacro
extends AbstractExecutedContentMacro<AsyncMacroParameters> {
    private static final String DESCRIPTION = "Asynchronous and cached execution of wiki content.";
    @Inject
    private AsyncContext asyncContext;

    public AsyncMacro() {
        super("Async", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor("Content to execute", true, Block.LIST_BLOCK_TYPE), AsyncMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public List<Block> execute(AsyncMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM xdom = this.parser.parse(content, context, false, context.isInline());
        if (xdom.getChildren().isEmpty()) {
            return Collections.emptyList();
        }
        String source = this.getCurrentSource(context);
        ArrayList<Object> idElements = new ArrayList<Object>(4);
        idElements.add("async");
        idElements.add("macro");
        if (parameters.getId() != null) {
            idElements.addAll(parameters.getId());
        } else {
            long index;
            if (source != null) {
                idElements.add(source);
            }
            if ((index = context.getXDOM().indexOf((Block)context.getCurrentMacroBlock())) != -1L) {
                idElements.add(index);
            }
        }
        BlockAsyncRendererConfiguration configuration = this.createBlockAsyncRendererConfiguration(idElements, (Block)xdom, source, context);
        configuration.setAsyncAllowed(parameters.isAsync());
        configuration.setCacheAllowed(parameters.isCached());
        configuration.addContextEntries(parameters.getContext());
        try {
            Block result = this.executor.execute(configuration);
            if (!parameters.isAsync() || !this.asyncContext.isEnabled()) {
                result = new MetaDataBlock(Collections.singletonList(result), this.getNonGeneratedContentMetaData());
            }
            return Collections.singletonList(result);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed start the execution of the macro", (Throwable)e);
        }
    }
}

