/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.cache.CacheControl;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.concurrent.ContextStoreManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.AsyncContextHandler;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.AsyncRendererCache;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.AsyncRendererExecutor;
import org.xwiki.rendering.async.internal.AsyncRendererExecutorResponse;
import org.xwiki.rendering.async.internal.AsyncRendererJob;
import org.xwiki.rendering.async.internal.AsyncRendererJobRequest;
import org.xwiki.rendering.async.internal.AsyncRendererJobStatus;
import org.xwiki.rendering.async.internal.AsyncRendererResult;
import org.xwiki.rendering.async.internal.DefaultAsyncContext;
import org.xwiki.security.authorization.AuthorExecutor;

@Component
@Singleton
public class DefaultAsyncRendererExecutor
implements AsyncRendererExecutor {
    @Inject
    @Named(value="asyncrenderer")
    private Provider<Job> jobProvider;
    @Inject
    private JobExecutor executor;
    @Inject
    private ContextStoreManager contextStore;
    @Inject
    private AsyncRendererCache cache;
    @Inject
    private AsyncContext asyncContext;
    @Inject
    protected AuthorExecutor authorExecutor;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private CacheControl cacheControl;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Logger logger;
    private AtomicLong clientIdCount = new AtomicLong();

    private String newClientId() {
        return String.valueOf(this.clientIdCount.incrementAndGet());
    }

    public AsyncRendererJobStatus getAsyncStatus(List<String> id, String clientId) {
        AsyncRendererJobStatus status;
        Job job = this.executor.getJob(id);
        if (job != null && (status = (AsyncRendererJobStatus)job.getStatus()).getClients().contains(clientId)) {
            return status;
        }
        status = this.cache.getAsync(clientId);
        if (status != null) {
            return status;
        }
        return null;
    }

    public AsyncRendererJobStatus getAsyncStatus(List<String> id, String clientId, long time, TimeUnit unit) throws InterruptedException {
        Job job;
        AsyncRendererJobStatus status = this.getAsyncStatus(id, clientId);
        if (status != null && status.getState() != JobStatus.State.FINISHED && (job = this.executor.getJob(id)) != null) {
            job.join(time, unit);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncRendererExecutorResponse render(AsyncRenderer renderer, AsyncRendererConfiguration configuration) throws JobException, RenderingException {
        AsyncRendererExecutorResponse response;
        boolean asyncAllowed = configuration.isPlaceHolderForced() || renderer.isAsyncAllowed() && this.asyncContext.isEnabled();
        boolean cacheAllowed = renderer.isCacheAllowed();
        Map<String, Serializable> context = this.getContext(asyncAllowed, cacheAllowed, configuration);
        List<String> jobId = this.getJobId(renderer, context);
        if (cacheAllowed) {
            this.cache.getLock().readLock().lock();
            try {
                AsyncRendererJobStatus status = this.getCurrent(jobId);
                if (status != null && (status.getEndDate() == null || this.cacheControl.isCacheReadAllowed(status.getEndDate()))) {
                    if (status.getResult() != null && !configuration.isPlaceHolderForced()) {
                        this.injectUses(status);
                        AsyncRendererExecutorResponse asyncRendererExecutorResponse = new AsyncRendererExecutorResponse(status);
                        return asyncRendererExecutorResponse;
                    }
                    if (asyncAllowed) {
                        AsyncRendererExecutorResponse asyncRendererExecutorResponse = new AsyncRendererExecutorResponse(status, this.newClientId());
                        return asyncRendererExecutorResponse;
                    }
                }
            }
            finally {
                this.cache.getLock().readLock().unlock();
            }
        }
        AsyncRendererJobRequest request = new AsyncRendererJobRequest();
        request.setRenderer(renderer);
        request.setJobGroupPath(renderer.getJobGroupPath());
        if (asyncAllowed) {
            this.cache.getLock().writeLock().lock();
            try {
                if (context != null) {
                    request.setContext(context);
                }
                String asyncClientId = this.newClientId();
                if (!renderer.isCacheAllowed()) {
                    jobId.add(asyncClientId);
                }
                request.setId(jobId);
                Job job = this.executor.execute("asyncrenderer", (Request)request);
                AsyncRendererJobStatus status = (AsyncRendererJobStatus)job.getStatus();
                response = new AsyncRendererExecutorResponse(status, asyncClientId);
            }
            finally {
                this.cache.getLock().writeLock().unlock();
            }
        } else {
            AsyncRendererJobStatus status;
            if (renderer.isCacheAllowed()) {
                DocumentReference currentDocumentReference;
                if (this.asyncContext instanceof DefaultAsyncContext) {
                    ((DefaultAsyncContext)this.asyncContext).pushContextUse();
                }
                if (configuration.getContextEntries() != null && configuration.getContextEntries().contains("doc.reference") && (currentDocumentReference = this.documentAccessBridge.getCurrentDocumentReference()) != null) {
                    this.asyncContext.useEntity((EntityReference)currentDocumentReference);
                }
                AsyncRendererResult result = this.syncRender(renderer, true, configuration);
                if (this.asyncContext instanceof DefaultAsyncContext) {
                    DefaultAsyncContext.ContextUse contextUse = ((DefaultAsyncContext)this.asyncContext).popContextUse();
                    status = new AsyncRendererJobStatus(request, result, contextUse.getReferences(), contextUse.getRoleTypes(), contextUse.getRoles(), contextUse.getRights(), contextUse.getUses());
                } else {
                    status = new AsyncRendererJobStatus(request, result, null, null, null, null, null);
                }
                request.setId(jobId);
                this.cache.put(status);
            } else {
                AsyncRendererResult result = this.syncRender(renderer, false, configuration);
                status = new AsyncRendererJobStatus(request, result);
            }
            response = new AsyncRendererExecutorResponse(status);
        }
        return response;
    }

    private AsyncRendererResult syncRender(AsyncRenderer renderer, boolean cached, AsyncRendererConfiguration configuration) throws RenderingException {
        if (configuration.isSecureReferenceSet()) {
            try {
                return (AsyncRendererResult)this.authorExecutor.call(() -> renderer.render(false, cached), configuration.getSecureAuthorReference(), configuration.getSecureDocumentReference());
            }
            catch (Exception e) {
                throw new RenderingException("Failed to execute renderer", (Throwable)e);
            }
        }
        return renderer.render(false, cached);
    }

    private void injectUses(AsyncRendererJobStatus status) {
        Map uses = status.getUses();
        if (uses != null) {
            for (Map.Entry entry : uses.entrySet()) {
                AsyncContextHandler handler;
                try {
                    handler = (AsyncContextHandler)this.componentManager.getInstance(AsyncContextHandler.class, (String)entry.getKey());
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Failed to get AsyncContextHandler with type [{}]", entry.getKey(), (Object)e);
                    continue;
                }
                handler.use((Collection)entry.getValue());
            }
        }
    }

    private Map<String, Serializable> getContext(boolean asyncAllowed, boolean cacheAllowed, AsyncRendererConfiguration configuration) throws JobException {
        HashMap<String, Object> savedContext = null;
        if (asyncAllowed || cacheAllowed) {
            if (configuration.getContextEntries() != null) {
                try {
                    savedContext = this.contextStore.save((Collection)configuration.getContextEntries());
                }
                catch (ComponentLookupException e) {
                    throw new JobException("Failed to save the context", (Throwable)e);
                }
            }
            if (asyncAllowed && configuration.isSecureReferenceSet()) {
                savedContext = savedContext == null ? new HashMap<String, DocumentReference>() : new HashMap(savedContext);
                savedContext.put("author", configuration.getSecureAuthorReference());
                savedContext.put("secureDocument", configuration.getSecureDocumentReference());
            }
        }
        return savedContext;
    }

    private AsyncRendererJobStatus getCurrent(List<String> jobId) {
        Job job = this.executor.getJob(jobId);
        if (job instanceof AsyncRendererJob) {
            return (AsyncRendererJobStatus)job.getStatus();
        }
        AsyncRendererJobStatus status = this.cache.getSync(jobId);
        if (status != null) {
            return status;
        }
        return null;
    }

    private List<String> getJobId(AsyncRenderer renderer, Map<String, Serializable> context) {
        List rendererId = renderer.getId();
        if (MapUtils.isEmpty(context)) {
            return rendererId;
        }
        TreeMap<String, Serializable> orderedMap = new TreeMap<String, Serializable>(context);
        ArrayList<String> id = new ArrayList<String>(rendererId.size() + orderedMap.size() * 2);
        id.addAll(rendererId);
        for (Map.Entry entry : orderedMap.entrySet()) {
            id.add((String)entry.getKey());
            id.add(this.encodeId(String.valueOf(entry.getValue())));
        }
        return id;
    }

    private String encodeId(String value) {
        StringBuilder builder = new StringBuilder(value.length() * 3);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            boolean encode = false;
            switch (c) {
                case '/': 
                case '\\': {
                    encode = true;
                    break;
                }
            }
            if (encode) {
                this.encode(c, builder);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private void encode(char c, StringBuilder builder) {
        byte[] ba = String.valueOf(c).getBytes(StandardCharsets.UTF_8);
        for (int j = 0; j < ba.length; ++j) {
            builder.append('%');
            char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
            builder.append(ch);
            ch = Character.forDigit(ba[j] & 0xF, 16);
            builder.append(ch);
        }
    }
}

