/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.component.descriptor.DefaultComponentRole;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;

public class BlockAsyncRendererConfiguration
extends AsyncRendererConfiguration {
    private List<String> id;
    private Block block;
    private XDOM xdom;
    private boolean asyncAllowed;
    private boolean cacheAllowed;
    private Syntax defaultSyntax;
    private String transformationId;
    private Syntax targetSyntax;
    private boolean inline;
    private boolean resricted;
    private BlockAsyncRendererDecorator decorator;
    private Set<EntityReference> references;
    private Set<ComponentRole<?>> roles;

    public BlockAsyncRendererConfiguration(List<?> idElements, Block block) {
        if (idElements != null) {
            this.id = new ArrayList<String>(idElements.size());
            this.addElements(idElements);
        } else {
            this.id = new ArrayList<String>();
        }
        this.block = block;
        this.asyncAllowed = true;
    }

    private void addElements(Iterable<?> elements) {
        for (Object element : elements) {
            if (element instanceof Iterable) {
                this.addElements((Iterable)element);
                continue;
            }
            this.id.add(element != null ? element.toString() : null);
        }
    }

    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public Block getBlock() {
        return this.block;
    }

    public XDOM getXDOM() {
        return this.xdom;
    }

    public void setXDOM(XDOM xdom) {
        this.xdom = xdom;
    }

    public boolean isAsyncAllowed() {
        return this.asyncAllowed;
    }

    public void setAsyncAllowed(boolean asyncAllowed) {
        this.asyncAllowed = asyncAllowed;
    }

    public boolean isCacheAllowed() {
        return this.cacheAllowed;
    }

    public void setCacheAllowed(boolean cacheAllowed) {
        this.cacheAllowed = cacheAllowed;
    }

    public Syntax getDefaultSyntax() {
        return this.defaultSyntax;
    }

    public void setDefaultSyntax(Syntax defaultSyntax) {
        this.defaultSyntax = defaultSyntax;
    }

    public String getTransformationId() {
        return this.transformationId;
    }

    public void setTransformationId(String transformationId) {
        this.transformationId = transformationId;
    }

    public Syntax getTargetSyntax() {
        return this.targetSyntax;
    }

    public void setTargetSyntax(Syntax targetSyntax) {
        this.targetSyntax = targetSyntax;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public boolean isResricted() {
        return this.resricted;
    }

    public void setResricted(boolean resricted) {
        this.resricted = resricted;
    }

    public BlockAsyncRendererDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(BlockAsyncRendererDecorator decorator) {
        this.decorator = decorator;
    }

    public Set<EntityReference> getReferences() {
        return this.references != null ? this.references : Collections.emptySet();
    }

    public void setReferences(Set<EntityReference> references) {
        this.references = new HashSet<EntityReference>(references);
    }

    public void useEntity(EntityReference reference) {
        if (this.references == null) {
            this.references = new HashSet<EntityReference>();
        }
        this.references.add(reference);
    }

    public Set<ComponentRole<?>> getRoles() {
        return this.roles != null ? this.roles : Collections.emptySet();
    }

    public void setRoles(Set<ComponentRole<?>> roles) {
        this.roles = roles;
    }

    public void useComponent(Type roleType) {
        if (this.roles == null) {
            this.roles = new HashSet();
        }
        this.roles.add((ComponentRole<?>)new DefaultComponentRole(roleType, null));
    }

    public void useComponent(Type roleType, String roleHint) {
        if (this.roles == null) {
            this.roles = new HashSet();
        }
        this.roles.add((ComponentRole<?>)new DefaultComponentRole(roleType, roleHint));
    }
}

