/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiGroupsDocumentInitializer;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.job.ReplaceUserRequest;
import org.xwiki.refactoring.script.RequestFactory;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="org.xwiki.refactoring.internal.listener.UpdateRightsOnDocumentRenameListener")
@Singleton
public class UpdateRightsOnDocumentRenameListener
extends AbstractLocalEventListener {
    public static final String NAME = "org.xwiki.refactoring.internal.listener.UpdateRightsOnDocumentRenameListener";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public UpdateRightsOnDocumentRenameListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        DocumentRenamedEvent documentRenamedEvent = (DocumentRenamedEvent)event;
        DocumentReference sourceReference = (DocumentReference)documentRenamedEvent.getSourceReference();
        DocumentReference targetReference = (DocumentReference)documentRenamedEvent.getTargetReference();
        this.processDocumentRenamed(sourceReference, targetReference);
    }

    private void processDocumentRenamed(DocumentReference sourceReference, DocumentReference targetReference) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            boolean definesUser;
            XWikiDocument document = context.getWiki().getDocument(targetReference, context);
            boolean definesGroup = document.getXObject((EntityReference)XWikiGroupsDocumentInitializer.XWIKI_GROUPS_DOCUMENT_REFERENCE) != null;
            boolean bl = definesUser = document.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE) != null;
            if (definesGroup) {
                this.refactorRightsAndGroupsInAllWikis(sourceReference, targetReference, false, context);
            }
            if (definesUser) {
                this.refactorRightsAndGroupsInAllWikis(sourceReference, targetReference, true, context);
                this.updateAuthors(sourceReference, targetReference);
            }
        }
        catch (XWikiException e) {
            this.logger.error("Error while updating rights objects after a rename of user or group [{}].", (Object)sourceReference, (Object)e);
        }
        catch (InterruptedException | ComponentLookupException e) {
            this.logger.error("Error while updating authors after a rename of user or group [{}].", (Object)sourceReference, (Object)e);
        }
        catch (WikiManagerException e) {
            this.logger.error("Error while looping over all wikis to update rights objects after a rename of user or group [{}].", (Object)sourceReference, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refactorRightsAndGroupsInAllWikis(DocumentReference sourceReference, DocumentReference targetReference, boolean isUser, XWikiContext context) throws WikiManagerException, XWikiException {
        String sourceWikiName = sourceReference.getWikiReference().getName();
        String targetWikiName = targetReference.getWikiReference().getName();
        List<String> wikiIds = context.isMainWiki(sourceWikiName) || context.isMainWiki(targetWikiName) ? this.wikiDescriptorManager.getAllIds() : (sourceWikiName.equals(targetWikiName) ? List.of(sourceWikiName) : List.of(sourceWikiName, targetWikiName));
        String currentWiki = context.getWikiId();
        try {
            for (String wikiId : wikiIds) {
                context.setWikiId(wikiId);
                RightsManager.getInstance().replaceUserOrGroupFromAllRights(sourceReference, targetReference, isUser, context);
                context.getWiki().getGroupService(context).replaceMemberInAllGroups(sourceReference, targetReference, context);
            }
        }
        finally {
            context.setWikiId(currentWiki);
        }
    }

    private void updateAuthors(DocumentReference sourceReference, DocumentReference targetReference) throws ComponentLookupException, InterruptedException {
        ReplaceUserRequest replaceUserRequest = this.requestFactory.createReplaceUserRequest(sourceReference, targetReference);
        replaceUserRequest.setReplaceDocumentAuthor(true);
        replaceUserRequest.setReplaceDocumentContentAuthor(true);
        replaceUserRequest.setReplaceDocumentCreator(true);
        replaceUserRequest.setCheckAuthorRights(false);
        Job replaceUserJob = (Job)this.componentManager.getInstance(Job.class, "refactoring/replaceUser");
        replaceUserJob.initialize((Request)replaceUserRequest);
        replaceUserJob.run();
        replaceUserJob.join();
    }
}

