/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.job.MoveRequest;

@Component
@Named(value="refactoring.updateObjectsOnClassRename")
@Singleton
public class UpdateObjectsOnClassRenameListener
extends AbstractLocalEventListener {
    public static final String NAME = "refactoring.updateObjectsOnClassRename";
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="unique")
    private QueryFilter uniqueFilter;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public UpdateObjectsOnClassRenameListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        boolean updateLinks = true;
        if (data instanceof MoveRequest) {
            updateLinks = ((MoveRequest)data).isUpdateLinks();
        }
        if (updateLinks) {
            DocumentRenamedEvent documentRenamedEvent = (DocumentRenamedEvent)event;
            this.updateObjects((DocumentReference)documentRenamedEvent.getSourceReference(), (DocumentReference)documentRenamedEvent.getTargetReference());
        }
    }

    private void updateObjects(DocumentReference oldClassReference, DocumentReference newClassReference) {
        if (!newClassReference.getWikiReference().equals((Object)oldClassReference.getWikiReference())) {
            return;
        }
        try {
            Query query = this.queryManager.createQuery(", BaseObject as obj where doc.fullName = obj.name and obj.className = :className", "hql");
            query.addFilter(this.uniqueFilter);
            query.setWiki(oldClassReference.getWikiReference().getName());
            query.bindValue("className", this.localEntityReferenceSerializer.serialize((EntityReference)oldClassReference, new Object[0]));
            List<DocumentReference> documentsToUpdate = query.execute().stream().map(fullName -> this.documentReferenceResolver.resolve(fullName, new Object[]{oldClassReference})).collect(Collectors.toList());
            if (!documentsToUpdate.isEmpty()) {
                this.updateObjects(documentsToUpdate, oldClassReference, newClassReference);
            }
        }
        catch (QueryException e) {
            this.logger.error("Failed to update the xobjects of type [{}] after the xclass has been renamed to [{}].", new Object[]{oldClassReference, newClassReference, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObjects(List<DocumentReference> documentsToUpdate, DocumentReference oldClassReference, DocumentReference newClassReference) {
        this.logger.info("Updating the xobjects of type [{}] after the xclass has been renamed to [{}].", (Object)oldClassReference, (Object)newClassReference);
        this.progressManager.pushLevelProgress(documentsToUpdate.size(), (Object)this);
        try {
            for (DocumentReference documentReference : documentsToUpdate) {
                this.progressManager.startStep((Object)this);
                try {
                    this.updateObjects(documentReference, oldClassReference, newClassReference);
                }
                catch (XWikiException e) {
                    this.logger.error("Failed to update the xobjects from [{}] after the xclass [{}] has been renamed to [{}].", new Object[]{documentReference, oldClassReference, newClassReference, e});
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void updateObjects(DocumentReference documentReference, DocumentReference oldClassReference, DocumentReference newClassReference) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        for (BaseObject oldObject : document.getXObjects(oldClassReference)) {
            if (oldObject == null) continue;
            BaseObject newObject = document.newXObject((EntityReference)newClassReference, xcontext);
            for (Object property : oldObject.getProperties()) {
                if (!(property instanceof BaseProperty)) continue;
                BaseProperty baseProperty = (BaseProperty)property;
                newObject.safeput(baseProperty.getName(), (PropertyInterface)baseProperty.clone());
            }
            document.removeXObject(oldObject);
        }
        xcontext.getWiki().saveDocument(document, String.format("Rename [%s] objects into [%s]", oldClassReference, newClassReference), xcontext);
    }
}

