/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.refactoring.internal.job.AbstractReplaceUserJob;
import org.xwiki.refactoring.job.ReplaceUserRequest;

@Component
@Named(value="refactoring/replaceUser")
public class ReplaceUserJob
extends AbstractReplaceUserJob {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    protected void update(DocumentReference documentReference) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            this.update(xcontext.getWiki().getDocument(documentReference, xcontext));
        }
        catch (XWikiException e) {
            this.logger.error("Failed to update document [{}]. Root cause is [{}].", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void update(XWikiDocument document) throws XWikiException {
        ArrayList<String> updatedFields = new ArrayList<String>();
        if (((ReplaceUserRequest)this.getRequest()).isReplaceDocumentAuthor() && Objects.equals(document.getAuthorReference(), ((ReplaceUserRequest)this.getRequest()).getOldUserReference())) {
            document.setAuthorReference(((ReplaceUserRequest)this.getRequest()).getNewUserReference());
            updatedFields.add("author");
        }
        if (((ReplaceUserRequest)this.getRequest()).isReplaceDocumentContentAuthor() && Objects.equals(document.getContentAuthorReference(), ((ReplaceUserRequest)this.getRequest()).getOldUserReference())) {
            document.setContentAuthorReference(((ReplaceUserRequest)this.getRequest()).getNewUserReference());
            updatedFields.add("contentAuthor");
        }
        if (((ReplaceUserRequest)this.getRequest()).isReplaceDocumentCreator() && Objects.equals(document.getCreatorReference(), ((ReplaceUserRequest)this.getRequest()).getOldUserReference())) {
            document.setCreatorReference(((ReplaceUserRequest)this.getRequest()).getNewUserReference());
            updatedFields.add("creator");
        }
        if (updatedFields.size() > 0) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            String comment = String.format("Replaced user [%s] in fields %s to user [%s]", ((ReplaceUserRequest)this.getRequest()).getOldUserReference(), updatedFields, ((ReplaceUserRequest)this.getRequest()).getNewUserReference());
            xcontext.getWiki().saveDocument(document, comment, xcontext);
        }
    }
}

