/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component(roles={ResourceReferenceRenamer.class})
@Singleton
public class ResourceReferenceRenamer {
    @Inject
    private EntityReferenceResolver<ResourceReference> entityReferenceResolver;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<ResourceReference> relativeEntityReferenceResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private DocumentReferenceResolver<EntityReference> defaultReferenceDocumentReferenceResolver;
    @Inject
    private PageReferenceResolver<EntityReference> defaultReferencePageReferenceResolver;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public boolean updateResourceReference(ResourceReference resourceReference, DocumentReference oldReference, DocumentReference newReference, DocumentReference currentDocumentReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) {
        return relative ? this.updateRelativeResourceReference(resourceReference, oldReference, newReference, updatedEntities) : this.updateAbsoluteResourceReference(resourceReference, oldReference, newReference, currentDocumentReference, updatedEntities);
    }

    private boolean checkIfDocExists(DocumentReference documentReference) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        boolean docExists = false;
        try {
            docExists = context.getWiki().exists(documentReference, context);
        }
        catch (XWikiException e) {
            this.logger.error("Error while checking if [{}] exists for link refactoring.", (Object)documentReference, (Object)e);
        }
        return docExists;
    }

    public boolean updateResourceReference(ResourceReference resourceReference, AttachmentReference oldReference, AttachmentReference newReference, DocumentReference currentDocumentReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) {
        return relative ? this.updateRelativeResourceReference(resourceReference, oldReference, newReference, updatedEntities) : this.updateAbsoluteResourceReference(resourceReference, oldReference, newReference, currentDocumentReference, updatedEntities);
    }

    private boolean updateAbsoluteResourceReference(ResourceReference resourceReference, DocumentReference oldReference, DocumentReference newReference, DocumentReference currentDocumentReference, Map<EntityReference, EntityReference> updatedEntities) {
        boolean shouldBeUpdated;
        boolean result = false;
        EntityReference linkEntityReference = this.entityReferenceResolver.resolve((Object)resourceReference, null, new Object[]{currentDocumentReference});
        DocumentReference linkTargetDocumentReference = this.defaultReferenceDocumentReferenceResolver.resolve((Object)linkEntityReference, new Object[0]);
        DocumentReference newTargetReference = newReference;
        ResourceType newResourceType = resourceReference.getType();
        EntityReference absoluteResolvedEntityReference = this.entityReferenceResolver.resolve((Object)resourceReference, null, new Object[0]);
        DocumentReference absoluteResolvedDocumentReference = this.defaultReferenceDocumentReferenceResolver.resolve((Object)absoluteResolvedEntityReference, new Object[0]);
        boolean bl = shouldBeUpdated = linkTargetDocumentReference.equals((Object)oldReference) && (absoluteResolvedDocumentReference.equals((Object)linkEntityReference) || !updatedEntities.containsKey(currentDocumentReference) || this.isPageReferenceOutOfParent(resourceReference, linkTargetDocumentReference, updatedEntities));
        if (shouldBeUpdated) {
            if (EntityType.SPACE.equals((Object)linkEntityReference.getType())) {
                if ("WebHome".equals(newReference.getName())) {
                    newTargetReference = newReference.getLastSpaceReference();
                } else {
                    newResourceType = ResourceType.DOCUMENT;
                }
            }
            if (EntityType.PAGE.equals((Object)linkEntityReference.getType())) {
                newTargetReference = this.defaultReferencePageReferenceResolver.resolve((Object)newReference, new Object[0]);
            }
            if (EntityType.ATTACHMENT.equals((Object)linkEntityReference.getType())) {
                newTargetReference = new AttachmentReference(linkEntityReference.getName(), newReference);
            }
            String newReferenceString = this.getNewTargetReference(resourceReference, (EntityReference)newTargetReference, (EntityReference)currentDocumentReference);
            resourceReference.setReference(newReferenceString);
            resourceReference.setType(newResourceType);
            result = true;
        }
        return result;
    }

    private String getNewTargetReference(ResourceReference resourceReference, EntityReference newTargetReference, EntityReference currentReference) {
        EntityReference entityReference = this.relativeEntityReferenceResolver.resolve((Object)resourceReference, null, new Object[]{null});
        if (entityReference.extractReference(EntityType.WIKI) != null) {
            return (String)this.defaultEntityReferenceSerializer.serialize(newTargetReference, new Object[]{currentReference});
        }
        return (String)this.compactEntityReferenceSerializer.serialize(newTargetReference, new Object[]{currentReference});
    }

    private boolean isPageReferenceOutOfParent(ResourceReference resourceReference, DocumentReference linkTargetDocumentReference, Map<EntityReference, EntityReference> updatedEntities) {
        boolean result = false;
        if (resourceReference.getType().equals((Object)ResourceType.PAGE) && resourceReference.getReference().startsWith("../")) {
            List spaceReferences = linkTargetDocumentReference.getSpaceReferences();
            result = updatedEntities.keySet().stream().anyMatch(entityReference -> {
                boolean match = false;
                if ("WebHome".equals(entityReference.getName())) {
                    EntityReference spaceReference = entityReference.extractReference(EntityType.SPACE);
                    match = spaceReference != null && spaceReferences.contains(spaceReference);
                }
                return match;
            });
        }
        return result;
    }

    private <T extends EntityReference> boolean updateRelativeResourceReference(ResourceReference resourceReference, T oldReference, T newReference, Map<EntityReference, EntityReference> updatedEntities) {
        boolean shouldBeUpdated;
        boolean result = false;
        EntityReference linkEntityReference = this.entityReferenceResolver.resolve((Object)resourceReference, null, new Object[]{newReference});
        EntityReference oldLinkReference = this.entityReferenceResolver.resolve((Object)resourceReference, null, new Object[]{oldReference});
        boolean docExists = false;
        EntityType entityType = linkEntityReference.getType();
        DocumentReference documentReference = null;
        DocumentReference documentReferenceTarget = null;
        if (entityType == EntityType.DOCUMENT || entityType.getAllowedParents().contains(EntityType.DOCUMENT)) {
            documentReference = (DocumentReference)oldLinkReference.extractReference(EntityType.DOCUMENT);
            documentReferenceTarget = (DocumentReference)linkEntityReference.extractReference(EntityType.DOCUMENT);
            docExists = this.checkIfDocExists(documentReference);
        } else {
            docExists = true;
        }
        boolean anyMatchInMovedReferences = oldLinkReference.hasParent(oldReference) || documentReferenceTarget != null && documentReferenceTarget.equals((Object)updatedEntities.get(documentReference));
        boolean bl = shouldBeUpdated = !anyMatchInMovedReferences && !linkEntityReference.equals((Object)oldLinkReference) && docExists;
        if (shouldBeUpdated) {
            String serializedLinkReference = this.getNewTargetReference(resourceReference, oldLinkReference, newReference);
            resourceReference.setReference(serializedLinkReference);
            result = true;
        }
        return result;
    }

    private boolean updateAbsoluteResourceReference(ResourceReference resourceReference, AttachmentReference oldReference, AttachmentReference newReference, DocumentReference currentDocumentReference, Map<EntityReference, EntityReference> updatedEntities) {
        boolean result = false;
        EntityReference linkEntityReference = this.entityReferenceResolver.resolve((Object)resourceReference, null, new Object[]{currentDocumentReference});
        if (linkEntityReference.equals((Object)oldReference)) {
            String newReferenceString = (String)this.compactEntityReferenceSerializer.serialize((EntityReference)newReference, new Object[]{currentDocumentReference});
            resourceReference.setReference(newReferenceString);
            result = true;
        }
        return result;
    }
}

