/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.ReferenceRenamer;
import org.xwiki.refactoring.internal.ResourceReferenceRenamer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.OrBlockMatcher;
import org.xwiki.rendering.configuration.ExtendedRenderingConfiguration;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroRefactoring;
import org.xwiki.rendering.macro.MacroRefactoringException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;

@Component
@Singleton
public class DefaultReferenceRenamer
implements ReferenceRenamer {
    private static final List<BlockMatcher> DEFAULT_BLOCK_MATCHERS = Arrays.asList(new ClassBlockMatcher(LinkBlock.class), new ClassBlockMatcher(ImageBlock.class), new ClassBlockMatcher(MacroBlock.class));
    private static final Set<ResourceType> SUPPORTED_RESOURCE_TYPES_FOR_DOCUMENTS = Set.of(ResourceType.DOCUMENT, ResourceType.SPACE, ResourceType.PAGE, ResourceType.ATTACHMENT, ResourceType.PAGE_ATTACHMENT);
    private static final Set<ResourceType> SUPPORTED_RESOURCE_TYPES_FOR_ATTACHMENTS = Set.of(ResourceType.ATTACHMENT, ResourceType.PAGE_ATTACHMENT);
    @Inject
    private Provider<MacroRefactoring> macroRefactoringProvider;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private ResourceReferenceRenamer resourceReferenceRenamer;
    @Inject
    private ExtendedRenderingConfiguration extendedRenderingConfiguration;
    @Inject
    private RenderingContext renderingContext;

    public boolean renameReferences(Block block, DocumentReference currentDocumentReference, DocumentReference oldTarget, DocumentReference newTarget, boolean relative, Map<EntityReference, EntityReference> updatedEntities) {
        return this.innerRenameReferences(block, currentDocumentReference, (EntityReference)oldTarget, (EntityReference)newTarget, SUPPORTED_RESOURCE_TYPES_FOR_DOCUMENTS, (macroRefactoring, macroBlock) -> macroRefactoring.replaceReference(macroBlock, currentDocumentReference, oldTarget, newTarget, relative, updatedEntities), reference -> this.resourceReferenceRenamer.updateResourceReference(reference, oldTarget, newTarget, currentDocumentReference, relative, updatedEntities));
    }

    public boolean renameReferences(Block block, DocumentReference currentDocumentReference, DocumentReference oldTarget, DocumentReference newTarget, boolean relative) {
        return this.renameReferences(block, currentDocumentReference, oldTarget, newTarget, relative, Map.of(oldTarget, newTarget));
    }

    public boolean renameReferences(Block block, DocumentReference currentDocumentReference, AttachmentReference oldTarget, AttachmentReference newTarget, boolean relative, Map<EntityReference, EntityReference> updatedEntities) {
        return this.innerRenameReferences(block, currentDocumentReference, (EntityReference)oldTarget, (EntityReference)newTarget, SUPPORTED_RESOURCE_TYPES_FOR_ATTACHMENTS, (macroRefactoring, macroBlock) -> macroRefactoring.replaceReference(macroBlock, currentDocumentReference, oldTarget, newTarget, relative, updatedEntities), reference -> this.resourceReferenceRenamer.updateResourceReference(reference, oldTarget, newTarget, currentDocumentReference, relative, updatedEntities));
    }

    public boolean renameReferences(Block block, DocumentReference currentDocumentReference, AttachmentReference oldTarget, AttachmentReference newTarget, boolean relative) {
        return this.renameReferences(block, currentDocumentReference, oldTarget, newTarget, relative, Map.of());
    }

    private boolean innerRenameReferences(Block block, DocumentReference currentDocumentReference, EntityReference oldTarget, EntityReference newTarget, Set<ResourceType> allowedResourceTypes, MacroRefactoringLambda macroRefactoringLambda, RenameResourceLambda renameResourceLambda) {
        List blocks = block.getBlocks((BlockMatcher)new OrBlockMatcher(DEFAULT_BLOCK_MATCHERS), Block.Axes.DESCENDANT);
        boolean modified = false;
        for (Block matchingBlock : blocks) {
            ResourceReference reference;
            if (matchingBlock instanceof MacroBlock) {
                MacroBlock macroBlock = (MacroBlock)matchingBlock;
                Optional<MacroBlock> optionalMacroBlock = this.handleMacroBlock(macroBlock, currentDocumentReference, oldTarget, newTarget, macroRefactoringLambda);
                if (!optionalMacroBlock.isPresent()) continue;
                macroBlock.getParent().replaceChild((Block)optionalMacroBlock.get(), (Block)macroBlock);
                modified = true;
                continue;
            }
            if (matchingBlock instanceof LinkBlock) {
                LinkBlock linkBlock = (LinkBlock)matchingBlock;
                reference = linkBlock.getReference();
            } else if (matchingBlock instanceof ImageBlock) {
                ImageBlock imageBlock = (ImageBlock)matchingBlock;
                reference = imageBlock.getReference();
            } else {
                throw new IllegalArgumentException(String.format("Only LinkBlock and ImageBlock can be processed and given class was: [%s]", matchingBlock.getClass().getName()));
            }
            modified |= this.renameResourceReference(reference, allowedResourceTypes, renameResourceLambda);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<MacroBlock> handleMacroBlock(MacroBlock macroBlock, DocumentReference currentDocumentReference, EntityReference oldTarget, EntityReference newTarget, MacroRefactoringLambda macroRefactoringLambda) {
        Syntax syntax;
        MacroRefactoring macroRefactoring = (MacroRefactoring)this.macroRefactoringProvider.get();
        if (this.componentManager.hasComponent(MacroRefactoring.class, macroBlock.getId())) {
            try {
                macroRefactoring = (MacroRefactoring)this.componentManager.getInstance(MacroRefactoring.class, macroBlock.getId());
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Error while getting the macro refactoring component for macro id [{}]: [{}].", (Object)macroBlock.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        try {
            syntax = this.documentAccessBridge.getDocumentInstance(currentDocumentReference).getSyntax();
        }
        catch (Exception e) {
            this.logger.warn("Error while trying to get syntax of the current document reference [{}]: [{}]", (Object)currentDocumentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            syntax = this.extendedRenderingConfiguration.getDefaultContentSyntax();
        }
        if (this.renderingContext instanceof MutableRenderingContext) {
            ((MutableRenderingContext)this.renderingContext).push(this.renderingContext.getTransformation(), this.renderingContext.getXDOM(), syntax, this.renderingContext.getTransformationId(), this.renderingContext.isRestricted(), this.renderingContext.getTargetSyntax());
        }
        try {
            Optional<MacroBlock> e = macroRefactoringLambda.call(macroRefactoring, macroBlock);
            return e;
        }
        catch (MacroRefactoringException e) {
            this.logger.warn("Error while trying to refactor reference from [{}] to [{}] in macro [{}] of document [{}]", new Object[]{oldTarget, newTarget, macroBlock.getId(), currentDocumentReference});
        }
        finally {
            if (this.renderingContext instanceof MutableRenderingContext) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
        }
        return Optional.empty();
    }

    private boolean renameResourceReference(ResourceReference reference, Set<ResourceType> allowedResourceTypes, RenameResourceLambda renameResourceLambda) {
        if (reference == null) {
            throw new IllegalArgumentException("The reference of  the block cannot be null.");
        }
        if (!allowedResourceTypes.contains(reference.getType())) {
            return false;
        }
        return renameResourceLambda.call(reference);
    }

    @FunctionalInterface
    private static interface MacroRefactoringLambda {
        public Optional<MacroBlock> call(MacroRefactoring var1, MacroBlock var2) throws MacroRefactoringException;
    }

    @FunctionalInterface
    private static interface RenameResourceLambda {
        public boolean call(ResourceReference var1);
    }
}

