/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.DeletedDocument;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.parentchild.ParentChildConfiguration;
import com.xpn.xwiki.store.XWikiRecycleBinStoreInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.api.AbstractCheckRightsRequest;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.link.LinkStore;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.refactoring.RefactoringException;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.internal.job.PermanentlyDeleteJob;

@Component
@Singleton
public class DefaultModelBridge
implements ModelBridge {
    private static final Pattern LIKE_SPECIAL_CHARS = Pattern.compile("([%_/])");
    private static final LocalDocumentReference REDIRECT_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "RedirectClass");
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeStringEntityReferenceResolver;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    private ParentChildConfiguration parentChildConfiguration;
    @Inject
    private EntityReferenceProvider entityReferenceProvider;
    @Inject
    private Provider<LinkStore> linkStoreProvider;

    public boolean create(DocumentReference documentReference) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument newDocument = xcontext.getWiki().getDocument(documentReference, xcontext);
            newDocument = newDocument.clone();
            xcontext.getWiki().saveDocument(newDocument, xcontext);
            this.logger.info("Document [{}] has been created.", (Object)documentReference);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to create document [{}].", (Object)documentReference, (Object)e);
            return false;
        }
    }

    public boolean copy(DocumentReference source, DocumentReference destination) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            String language = source.getLocale() != null ? source.getLocale().toString() : null;
            boolean result = xcontext.getWiki().copyDocument(source, destination, language, false, true, true, xcontext);
            if (result) {
                this.logger.info("Document [{}] has been copied to [{}].", (Object)source, (Object)destination);
            } else {
                this.logger.warn("Cannot fully copy [{}] to [{}] because an orphan translation exists at the destination.", (Object)source, (Object)destination);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to copy [{}] to [{}].", new Object[]{source, destination, e});
            return false;
        }
    }

    public boolean delete(DocumentReference reference) {
        return this.delete(reference, false);
    }

    public boolean delete(DocumentReference reference, boolean skipRecycleBin) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document = xcontext.getWiki().getDocument(reference, xcontext);
            if (document.getTranslation() == 1) {
                xcontext.getWiki().deleteDocument(document, !skipRecycleBin, xcontext);
                this.logger.info("Document [{}] has been deleted (to the recycle bin: [{}]).", (Object)reference, (Object)(!skipRecycleBin ? 1 : 0));
            } else {
                xcontext.getWiki().deleteAllDocuments(document, !skipRecycleBin, xcontext);
                this.logger.info("Document [{}] has been deleted with all its translations (to the recycle bin: [{}]).", (Object)reference, (Object)(!skipRecycleBin ? 1 : 0));
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to delete document [{}] (to the recycle bin: [{}]).", new Object[]{reference, !skipRecycleBin, e});
            return false;
        }
    }

    public boolean removeLock(DocumentReference reference) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document = xcontext.getWiki().getDocument(reference, xcontext);
            if (document.getLock(xcontext) != null) {
                document.removeLock(xcontext);
                this.logger.info("Document [{}] has been unlocked.", (Object)reference);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.warn("Failed to unlock document [{}].", (Object)reference, (Object)e);
            return false;
        }
    }

    public void createRedirect(DocumentReference oldReference, DocumentReference newReference) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference redirectClassReference = new DocumentReference(REDIRECT_CLASS_REFERENCE, oldReference.getWikiReference());
        try {
            if (xcontext.getWiki().exists(redirectClassReference, xcontext)) {
                XWikiDocument oldDocument = xcontext.getWiki().getDocument(oldReference, xcontext);
                oldDocument = oldDocument.clone();
                int number = oldDocument.createXObject((EntityReference)redirectClassReference, xcontext);
                String location = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)newReference, new Object[0]);
                oldDocument.getXObject(redirectClassReference, number).setStringValue("location", location);
                oldDocument.setHidden(Boolean.valueOf(true));
                xcontext.getWiki().saveDocument(oldDocument, "Create automatic redirect.", xcontext);
                this.logger.info("Created automatic redirect from [{}] to [{}].", (Object)oldReference, (Object)newReference);
            } else {
                this.logger.warn("We can't create an automatic redirect from [{}] to [{}] because [{}] is missing.", new Object[]{oldReference, newReference, redirectClassReference});
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to create automatic redirect from [{}] to [{}].", new Object[]{oldReference, newReference, e});
        }
    }

    public boolean canOverwriteSilently(DocumentReference documentReference) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
            DocumentReference redirectClassReference = new DocumentReference(REDIRECT_CLASS_REFERENCE, documentReference.getWikiReference());
            return document.getXObject(redirectClassReference) != null;
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get document [{}]. Root cause: [{}].", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }

    public boolean exists(DocumentReference reference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.getWiki().exists(reference, xcontext);
    }

    public Set<DocumentReference> getBackLinkedDocuments(EntityReference reference) throws RefactoringException {
        Set references;
        try {
            references = ((LinkStore)this.linkStoreProvider.get()).resolveBackLinkedEntities(reference);
        }
        catch (Exception e) {
            throw new RefactoringException("Failed to resolve backlinks for entity [" + String.valueOf(reference) + "]", (Throwable)e);
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        HashSet<DocumentReference> documentReferences = new HashSet<DocumentReference>(references.size());
        for (EntityReference entityReference : references) {
            documentReferences.add(this.documentReferenceResolver.resolve((Object)entityReference, new Object[]{xcontext}));
        }
        return documentReferences;
    }

    public List<DocumentReference> getDocumentReferences(SpaceReference spaceReference) {
        try {
            String statement = "select distinct(doc.fullName) from XWikiDocument as doc where doc.space = :space or doc.space like :spacePrefix escape '/'";
            Query query = this.queryManager.createQuery(statement, "hql");
            query.setWiki(spaceReference.getWikiReference().getName());
            String localSpaceReference = (String)this.localEntityReferenceSerializer.serialize((EntityReference)spaceReference, new Object[0]);
            query.bindValue("space", (Object)localSpaceReference);
            String spacePrefix = LIKE_SPECIAL_CHARS.matcher(localSpaceReference).replaceAll("/$1");
            query.bindValue("spacePrefix", (Object)(spacePrefix + ".%"));
            ArrayList<DocumentReference> descendants = new ArrayList<DocumentReference>();
            for (Object fullName : query.execute()) {
                descendants.add(this.explicitDocumentReferenceResolver.resolve((Object)((String)fullName), new Object[]{spaceReference}));
            }
            return descendants;
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve the documents from [{}].", (Object)spaceReference, (Object)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateParentField(DocumentReference oldParentReference, DocumentReference newParentReference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki wiki = context.getWiki();
        boolean popLevelProgress = false;
        try {
            XWikiDocument oldParentDocument = wiki.getDocument(oldParentReference, context);
            List childReferences = oldParentDocument.getChildrenReferences(context);
            if (childReferences.size() > 0) {
                this.progressManager.pushLevelProgress(childReferences.size(), (Object)this);
                popLevelProgress = true;
            }
            for (DocumentReference childReference : childReferences) {
                this.progressManager.startStep((Object)this);
                XWikiDocument childDocument = wiki.getDocument(childReference, context);
                childDocument = childDocument.clone();
                childDocument.setParentReference((EntityReference)newParentReference);
                wiki.saveDocument(childDocument, "Updated parent field.", true, context);
                this.progressManager.endStep((Object)this);
            }
            if (childReferences.size() > 0) {
                this.logger.info("Document parent fields updated from [{}] to [{}] for [{}] documents.", new Object[]{oldParentReference, newParentReference, childReferences.size()});
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update the document parent fields from [{}] to [{}].", new Object[]{oldParentReference, newParentReference, e});
            boolean bl = false;
            return bl;
        }
        finally {
            if (popLevelProgress) {
                this.progressManager.popLevelProgress((Object)this);
            }
        }
        return true;
    }

    public DocumentReference setContextUserReference(DocumentReference userReference) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference previousUserReference = context.getUserReference();
        context.setUserReference(userReference);
        return previousUserReference;
    }

    public void update(DocumentReference documentReference, Map<String, String> parameters) {
        try {
            EntityReference newDocumentParentRef;
            DocumentReference hierarchicalParent;
            String hierarchicalParentSerialized;
            EntityReference relativeHierarchicalReference;
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWiki wiki = context.getWiki();
            XWikiDocument document = wiki.getDocument(documentReference, context);
            boolean save = false;
            String title = parameters.get("title");
            if (title != null && !title.equals(document.getTitle())) {
                if (!save) {
                    document = document.clone();
                }
                document.setTitle(title);
                save = true;
            }
            if (!this.parentChildConfiguration.isParentChildMechanismEnabled() && !(relativeHierarchicalReference = this.relativeStringEntityReferenceResolver.resolve((Object)(hierarchicalParentSerialized = (String)this.compactEntityReferenceSerializer.serialize((EntityReference)(hierarchicalParent = this.getHierarchicalParent(documentReference)), new Object[]{documentReference})), EntityType.DOCUMENT, new Object[0])).equals((Object)(newDocumentParentRef = document.getRelativeParentReference()))) {
                if (!save) {
                    document = document.clone();
                }
                document.setParentReference(relativeHierarchicalReference);
                save = true;
            }
            if (save) {
                wiki.saveDocument(document, "Update document after refactoring.", true, context);
                this.logger.info("Document [{}] has been updated.", (Object)documentReference);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update the document [{}] after refactoring.", (Object)documentReference, (Object)e);
        }
    }

    private DocumentReference getHierarchicalParent(DocumentReference documentReference) {
        String spaceHomePage = this.entityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        EntityReference parentOfTheSpace = documentReference.getLastSpaceReference().getParent();
        boolean pageIsNotTerminal = documentReference.getName().equals(spaceHomePage);
        if (pageIsNotTerminal && parentOfTheSpace.getType() == EntityType.SPACE) {
            return new DocumentReference(spaceHomePage, new SpaceReference(parentOfTheSpace));
        }
        if (pageIsNotTerminal && parentOfTheSpace.getType() == EntityType.WIKI) {
            return new DocumentReference(spaceHomePage, new SpaceReference(this.entityReferenceProvider.getDefaultReference(EntityType.SPACE).getName(), documentReference.getWikiReference()));
        }
        return new DocumentReference(spaceHomePage, documentReference.getLastSpaceReference());
    }

    private XWikiDeletedDocument getDeletedDocument(XWikiContext context, long deletedDocumentId) throws XWikiException {
        XWiki xWiki = context.getWiki();
        XWikiDeletedDocument deletedDocument = xWiki.getDeletedDocument(deletedDocumentId, context);
        if (deletedDocument == null) {
            this.logger.error("Deleted document with ID [{}] does not exist.", (Object)deletedDocumentId);
            return null;
        }
        return deletedDocument;
    }

    public boolean restoreDeletedDocument(long deletedDocumentId, AbstractCheckRightsRequest request) {
        block7: {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = context.getWiki();
            DocumentReference deletedDocumentReference = null;
            try {
                XWikiDeletedDocument deletedDocument = this.getDeletedDocument(context, deletedDocumentId);
                if (deletedDocument == null) {
                    return false;
                }
                deletedDocumentReference = deletedDocument.getDocumentReference();
                if (xwiki.exists(deletedDocumentReference, context)) {
                    this.logger.error("Document [{}] with ID [{}] can not be restored. Document already exists", (Object)deletedDocument.getFullName(), (Object)deletedDocumentId);
                    break block7;
                }
                if (request.isCheckAuthorRights() && !this.canRestoreDeletedDocument(deletedDocument, context.getAuthorReference())) {
                    this.logger.error("The author [{}] of this script is not allowed to restore document [{}] with ID [{}]", new Object[]{context.getAuthorReference(), deletedDocumentReference, deletedDocumentId});
                    break block7;
                }
                if (request.isCheckRights() && !this.canRestoreDeletedDocument(deletedDocument, context.getUserReference())) {
                    this.logger.error("You are not allowed to restore document [{}] with ID [{}]", (Object)deletedDocumentReference, (Object)deletedDocumentId);
                    break block7;
                }
                xwiki.restoreFromRecycleBin(deletedDocument.getId(), "Restored from recycle bin", context);
                this.logger.info("Document [{}] has been restored", (Object)deletedDocumentReference);
                return true;
            }
            catch (Exception e) {
                if (deletedDocumentReference != null) {
                    this.logger.error("Failed to restore document [{}] with ID [{}]", new Object[]{deletedDocumentReference, deletedDocumentId, e});
                }
                this.logger.error("Failed to restore deleted document with ID [{}]", (Object)deletedDocumentId, (Object)e);
            }
        }
        return false;
    }

    public List<Long> getDeletedDocumentIds(String batchId) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            XWikiDeletedDocument[] deletedDocuments;
            for (XWikiDeletedDocument deletedDocument : deletedDocuments = xwiki.getRecycleBinStore().getAllDeletedDocuments(batchId, false, context, true)) {
                result.add(deletedDocument.getId());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get deleted document IDs for batch [{}]", (Object)batchId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canRestoreDeletedDocument(XWikiDeletedDocument deletedDocument, DocumentReference userReference) {
        boolean result = false;
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference currentUserReference = context.getUserReference();
        try {
            DeletedDocument deletedDocumentApi = new DeletedDocument(deletedDocument, context);
            context.setUserReference(userReference);
            result = deletedDocumentApi.canUndelete();
        }
        catch (Exception e) {
            this.logger.error("Failed to check restore rights on deleted document [{}] for user [{}]", new Object[]{deletedDocument.getId(), userReference, e});
        }
        finally {
            context.setUserReference(currentUserReference);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canPermanentlyDeleteDocument(XWikiDeletedDocument deletedDocument, DocumentReference userReference) {
        boolean result = false;
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference currentUserReference = context.getUserReference();
        try {
            DeletedDocument deletedDocumentApi = new DeletedDocument(deletedDocument, context);
            context.setUserReference(userReference);
            result = deletedDocumentApi.canDelete();
        }
        catch (Exception e) {
            this.logger.error("Failed to check delete rights on deleted document [{}] for user [{}]", new Object[]{deletedDocument.getId(), userReference, e});
        }
        finally {
            context.setUserReference(currentUserReference);
        }
        return result;
    }

    public boolean permanentlyDeleteDocument(long deletedDocumentId, AbstractCheckRightsRequest request) {
        block6: {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = context.getWiki();
            DocumentReference deletedDocumentReference = null;
            try {
                XWikiDeletedDocument deletedDocument = this.getDeletedDocument(context, deletedDocumentId);
                if (deletedDocument == null) {
                    return false;
                }
                deletedDocumentReference = deletedDocument.getDocumentReference();
                if (request.isCheckRights() && !this.canPermanentlyDeleteDocument(deletedDocument, context.getUserReference())) {
                    this.logger.error("You are not allowed to permanently delete document [{}] with ID [{}]", (Object)deletedDocumentReference, (Object)deletedDocumentId);
                    break block6;
                }
                if (request.isCheckAuthorRights() && !this.canPermanentlyDeleteDocument(deletedDocument, context.getAuthorReference())) {
                    this.logger.error("The author [{}] of this script is not allowed to permanently deleted document [{}] with id [{}]", new Object[]{context.getAuthorReference(), deletedDocumentReference, deletedDocumentId});
                    break block6;
                }
                xwiki.getRecycleBinStore().deleteFromRecycleBin(deletedDocumentId, context, true);
                this.logger.info("Document [{}] has been permanently deleted.", (Object)deletedDocumentReference);
                return true;
            }
            catch (Exception e) {
                if (deletedDocumentReference != null) {
                    this.logger.error("Failed to permanently delete document [{}] with ID [{}]", new Object[]{deletedDocumentReference, deletedDocumentId, e});
                }
                this.logger.error("Failed to permanently delete document with ID [{}]", (Object)deletedDocumentId, (Object)e);
            }
        }
        return false;
    }

    public boolean permanentlyDeleteAllDocuments(PermanentlyDeleteJob deleteJob, AbstractCheckRightsRequest request) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        int limit = 10;
        XWikiRecycleBinStoreInterface recycleBinStore = xwiki.getRecycleBinStore();
        try {
            int nbDocToDelete;
            long numberOfDocumentsToDelete = recycleBinStore.getNumberOfDeletedDocuments(context);
            if (numberOfDocumentsToDelete > Integer.MAX_VALUE) {
                this.logger.warn("Only [{}] file can be deleted at once. Please run again the job to delete everything.", (Object)Integer.MAX_VALUE);
                nbDocToDelete = Integer.MAX_VALUE;
            } else {
                nbDocToDelete = Integer.valueOf("" + numberOfDocumentsToDelete);
            }
            this.progressManager.pushLevelProgress(nbDocToDelete, (Object)deleteJob);
            for (int i = 0; i < nbDocToDelete; i += limit) {
                Long[] allDeletedDocumentsIds;
                for (Long deletedDocumentsId : allDeletedDocumentsIds = recycleBinStore.getAllDeletedDocumentsIds(context, limit)) {
                    if (((AbstractJobStatus)deleteJob.getStatus()).isCanceled()) {
                        return false;
                    }
                    this.progressManager.startStep((Object)deleteJob);
                    this.permanentlyDeleteDocument(deletedDocumentsId, request);
                    this.progressManager.endStep((Object)deleteJob);
                }
            }
            return true;
        }
        catch (XWikiException e) {
            this.logger.error("Failed to permanently delete all documents", (Throwable)e);
            return false;
        }
    }

    public boolean rename(DocumentReference source, DocumentReference destination) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            return xcontext.getWiki().renameDocument(source, destination, true, Collections.emptyList(), Collections.emptyList(), xcontext);
        }
        catch (Exception e) {
            this.logger.error("Failed to rename [{}] to [{}].", new Object[]{source, destination, e});
            return false;
        }
    }
}

