/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.ReferenceRenamer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.LinkParser;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.MacroRefactoring;
import org.xwiki.rendering.macro.MacroRefactoringException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;

@Component
@Singleton
public class DefaultMacroRefactoring
implements MacroRefactoring {
    @Inject
    private MacroManager macroManager;
    @Inject
    private MacroContentParser macroContentParser;
    @Inject
    private Provider<ReferenceRenamer> referenceRenamerProvider;
    @Inject
    private Provider<LinkParser> linkParserProvider;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Logger logger;

    private boolean shouldMacroContentBeParsed(Macro<?> macro) {
        ContentDescriptor contentDescriptor = macro.getDescriptor().getContentDescriptor();
        return contentDescriptor != null && Block.LIST_BLOCK_TYPE.equals(contentDescriptor.getType());
    }

    private Macro<?> getMacro(MacroBlock macroBlock, Syntax syntax) {
        MacroId macroId = new MacroId(macroBlock.getId(), syntax);
        try {
            return this.macroManager.getMacro(macroId);
        }
        catch (MacroLookupException e) {
            this.logger.debug("Cannot get macro with id [{}]: [{}]", (Object)macroId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private MacroTransformationContext getTransformationContext(MacroBlock macroBlock) {
        MacroTransformationContext macroTransformationContext = new MacroTransformationContext();
        macroTransformationContext.setId("refactoring_" + macroBlock.getId());
        macroTransformationContext.setCurrentMacroBlock(macroBlock);
        macroTransformationContext.setSyntax(this.renderingContext.getDefaultSyntax());
        macroTransformationContext.setInline(macroBlock.isInline());
        return macroTransformationContext;
    }

    private MacroBlock renderMacroBlock(MacroBlock originalBlock, XDOM newXDOMContent, Syntax syntax) throws ComponentLookupException {
        BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, syntax.toIdString());
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.render((Block)newXDOMContent, (WikiPrinter)printer);
        String content = printer.toString();
        return new MacroBlock(originalBlock.getId(), originalBlock.getParameters(), content, originalBlock.isInline());
    }

    private XDOM parseMacro(MacroBlock macroBlock) throws MacroRefactoringException {
        MacroTransformationContext transformationContext = this.getTransformationContext(macroBlock);
        Syntax renderingSyntax = this.macroContentParser.getCurrentSyntax(transformationContext);
        Macro<?> macro = this.getMacro(macroBlock, renderingSyntax);
        if (macro != null && this.shouldMacroContentBeParsed(macro)) {
            try {
                return this.macroContentParser.parse(macroBlock.getContent(), transformationContext, true, macroBlock.isInline());
            }
            catch (MacroExecutionException e) {
                throw new MacroRefactoringException("Error while parsing macro content for reference replacement", (Throwable)e);
            }
        }
        return null;
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, DocumentReference sourceReference, DocumentReference targetReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) throws MacroRefactoringException {
        return this.innerReplaceReference(macroBlock, xdom -> ((ReferenceRenamer)this.referenceRenamerProvider.get()).renameReferences(xdom, currentDocumentReference, sourceReference, targetReference, relative, updatedEntities));
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, AttachmentReference sourceReference, AttachmentReference targetReference, boolean relative, Map<EntityReference, EntityReference> updatedEntities) throws MacroRefactoringException {
        return this.innerReplaceReference(macroBlock, xdom -> ((ReferenceRenamer)this.referenceRenamerProvider.get()).renameReferences(xdom, currentDocumentReference, sourceReference, targetReference, relative, updatedEntities));
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, DocumentReference sourceReference, DocumentReference targetReference, boolean relative) throws MacroRefactoringException {
        return this.replaceReference(macroBlock, currentDocumentReference, sourceReference, targetReference, relative, Map.of(sourceReference, targetReference));
    }

    public Optional<MacroBlock> replaceReference(MacroBlock macroBlock, DocumentReference currentDocumentReference, AttachmentReference sourceReference, AttachmentReference targetReference, boolean relative) throws MacroRefactoringException {
        return this.replaceReference(macroBlock, currentDocumentReference, sourceReference, targetReference, relative, Map.of(sourceReference.getDocumentReference(), targetReference.getDocumentReference()));
    }

    private Optional<MacroBlock> innerReplaceReference(MacroBlock macroBlock, Predicate<Block> lambda) throws MacroRefactoringException {
        XDOM xdom = this.parseMacro(macroBlock);
        MacroTransformationContext transformationContext = this.getTransformationContext(macroBlock);
        Syntax renderingSyntax = this.macroContentParser.getCurrentSyntax(transformationContext);
        if (xdom != null) {
            try {
                boolean updated = lambda.test((Block)xdom);
                if (updated) {
                    return Optional.of(this.renderMacroBlock(macroBlock, xdom, renderingSyntax));
                }
            }
            catch (ComponentLookupException e) {
                throw new MacroRefactoringException("Error while rendering macro content after reference replacement ", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Set<ResourceReference> extractReferences(MacroBlock macroBlock) throws MacroRefactoringException {
        XDOM xdom = this.parseMacro(macroBlock);
        if (xdom != null) {
            return ((LinkParser)this.linkParserProvider.get()).extractReferences(xdom);
        }
        return Collections.emptySet();
    }
}

