/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.RatingsManagerFactory;
import org.xwiki.ratings.script.AbstractScriptRatingsManager;
import org.xwiki.ratings.script.DefaultScriptRatingsManager;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
@Named(value="ratings")
public class RatingsScriptService
extends AbstractScriptRatingsManager
implements Initializable,
ScriptService {
    static final String EXECUTION_CONTEXT_PREFIX = "ratings.script.";
    @Inject
    private RatingsManagerFactory ratingsManagerFactory;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    public void initialize() throws InitializationException {
        try {
            this.setRatingsManager(this.ratingsManagerFactory.getRatingsManager("ratings"));
        }
        catch (RatingsException e) {
            throw new InitializationException("Error when trying to retrieve the instance of RatingsManager", (Throwable)e);
        }
    }

    public DefaultScriptRatingsManager get(String managerHint) {
        ExecutionContext executionContext = this.execution.getContext();
        String executionContextCacheKey = EXECUTION_CONTEXT_PREFIX + managerHint;
        DefaultScriptRatingsManager scriptRatingsManager = null;
        if (executionContext.hasProperty(executionContextCacheKey)) {
            scriptRatingsManager = (DefaultScriptRatingsManager)executionContext.getProperty(executionContextCacheKey);
        } else {
            try {
                RatingsManager ratingsManager = this.ratingsManagerFactory.getRatingsManager(managerHint);
                scriptRatingsManager = (DefaultScriptRatingsManager)this.componentManager.getInstance(DefaultScriptRatingsManager.class);
                scriptRatingsManager.setRatingsManager(ratingsManager);
                executionContext.setProperty(executionContextCacheKey, (Object)scriptRatingsManager);
            }
            catch (RatingsException e) {
                this.logger.error(String.format("Error when trying to retrieve RatingsManager instance with hint [%s]", managerHint), (Throwable)e);
            }
            catch (ComponentLookupException e) {
                this.logger.error(String.format("Error when trying to retrieve DefaultScriptRatingsManager instance with hint [%s]", managerHint), (Throwable)e);
            }
        }
        return scriptRatingsManager;
    }
}

