/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.averagerating;

import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.AverageRating;
import org.xwiki.text.XWikiToStringBuilder;

public class DefaultAverageRating
implements AverageRating {
    private String identifier;
    private String managerId;
    private EntityReference reference;
    private float averageVote;
    private int totalVote;
    private int scale;
    private Date updatedAt;

    public DefaultAverageRating(String identifier) {
        this.identifier = identifier;
        this.updatedAt = new Date();
    }

    public DefaultAverageRating(AverageRating averageRating) {
        this.identifier = averageRating.getId();
        this.managerId = averageRating.getManagerId();
        this.reference = averageRating.getReference();
        this.averageVote = averageRating.getAverageVote();
        this.totalVote = averageRating.getNbVotes();
        this.scale = averageRating.getScaleUpperBound();
        this.updatedAt = averageRating.getUpdatedAt();
    }

    @Override
    public AverageRating updateRating(int oldRating, int newRating) {
        float newTotal = this.averageVote * (float)this.totalVote - (float)oldRating + (float)newRating;
        this.averageVote = newTotal / (float)this.totalVote;
        this.updatedAt = new Date();
        return this;
    }

    @Override
    public AverageRating removeRating(int rating) {
        float newTotal = this.averageVote * (float)this.totalVote - (float)rating;
        --this.totalVote;
        this.averageVote = this.totalVote > 0 ? newTotal / (float)this.totalVote : 0.0f;
        this.updatedAt = new Date();
        return this;
    }

    @Override
    public AverageRating addRating(int rating) {
        float newTotal = this.averageVote * (float)this.totalVote + (float)rating;
        ++this.totalVote;
        this.averageVote = newTotal / (float)this.totalVote;
        this.updatedAt = new Date();
        return this;
    }

    public DefaultAverageRating setManagerId(String managerId) {
        this.managerId = managerId;
        return this;
    }

    public DefaultAverageRating setReference(EntityReference reference) {
        this.reference = reference;
        return this;
    }

    public DefaultAverageRating setAverageVote(float averageVote) {
        this.averageVote = averageVote;
        return this;
    }

    public DefaultAverageRating setTotalVote(int totalVote) {
        this.totalVote = totalVote;
        return this;
    }

    public DefaultAverageRating setScaleUpperBound(int scale) {
        this.scale = scale;
        return this;
    }

    public DefaultAverageRating setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public String getId() {
        return this.identifier;
    }

    @Override
    public String getManagerId() {
        return this.managerId;
    }

    @Override
    public EntityReference getReference() {
        return this.reference;
    }

    @Override
    public float getAverageVote() {
        return this.averageVote;
    }

    @Override
    public int getNbVotes() {
        return this.totalVote;
    }

    @Override
    public int getScaleUpperBound() {
        return this.scale;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAverageRating that = (DefaultAverageRating)o;
        return new EqualsBuilder().append(this.averageVote, that.averageVote).append(this.totalVote, that.totalVote).append(this.scale, that.scale).append((Object)this.identifier, (Object)that.identifier).append((Object)this.managerId, (Object)that.managerId).append((Object)this.reference, (Object)that.reference).append((Object)this.updatedAt, (Object)that.updatedAt).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 67).append((Object)this.identifier).append((Object)this.managerId).append((Object)this.reference).append(this.averageVote).append(this.totalVote).append(this.scale).append((Object)this.updatedAt).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("identifier", (Object)this.identifier).append("managerId", (Object)this.managerId).append("reference", (Object)this.reference).append("averageVote", this.averageVote).append("totalVote", this.totalVote).append("scale", this.scale).append("updatedAt", (Object)this.updatedAt).toString();
    }
}

