/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.averagerating;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ElementInterface;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentUpdatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.events.UpdatingAverageRatingEvent;
import org.xwiki.ratings.internal.averagerating.AverageRatingClassDocumentInitializer;

@Component
@Singleton
@Named(value="AverageRatingProtectionListener")
public class AverageRatingProtectionListener
extends AbstractEventListener {
    private static final UpdatingAverageRatingEvent PARENT = new UpdatingAverageRatingEvent();
    @Inject
    private ObservationContext observationContext;

    public AverageRatingProtectionListener() {
        super("AverageRatingProtectionListener", new Event[]{new DocumentUpdatingEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        if (!this.observationContext.isIn((BeginEvent)PARENT)) {
            List xObjects = document.getXObjects((EntityReference)AverageRatingClassDocumentInitializer.AVERAGE_RATINGS_CLASSREFERENCE);
            XWikiDocument previousDocument = document.getOriginalDocument();
            for (BaseObject ratingXObject : xObjects) {
                int number;
                BaseObject previousObject;
                if (ratingXObject == null || (previousObject = previousDocument.getXObject((EntityReference)AverageRatingClassDocumentInitializer.AVERAGE_RATINGS_CLASSREFERENCE, number = ratingXObject.getNumber())) == null) continue;
                ratingXObject.apply((ElementInterface)previousObject, true);
            }
        }
    }
}

