/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.averagerating;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.AverageRating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.events.UpdateAverageRatingFailedEvent;
import org.xwiki.ratings.events.UpdatedAverageRatingEvent;
import org.xwiki.ratings.events.UpdatingAverageRatingEvent;
import org.xwiki.ratings.internal.averagerating.AverageRatingManager;
import org.xwiki.ratings.internal.averagerating.DefaultAverageRating;

public abstract class AbstractAverageRatingManager
implements AverageRatingManager {
    private RatingsManager ratingsManager;
    @Inject
    private ObservationManager observationManager;

    @Override
    public void setRatingsManager(RatingsManager ratingsManager) {
        this.ratingsManager = ratingsManager;
    }

    protected String getIdentifier() {
        return this.ratingsManager.getIdentifier();
    }

    protected ObservationManager getObservationManager() {
        return this.observationManager;
    }

    protected int getScale() {
        return this.ratingsManager.getScale();
    }

    protected AverageRating createAverageRating(EntityReference entityReference, String id) {
        return new DefaultAverageRating(id).setManagerId(this.getIdentifier()).setScaleUpperBound(this.getScale()).setReference(entityReference).setAverageVote(0.0f).setTotalVote(0);
    }

    protected abstract void saveAverageRating(AverageRating var1) throws RatingsException;

    private AverageRating updateAverageRating(AverageRating averageRating, float oldAverageVote, int oldTotalVote) throws RatingsException {
        List<AverageRating> averageRatingList = Collections.singletonList(averageRating);
        this.getObservationManager().notify((Event)new UpdatingAverageRatingEvent(averageRating, oldAverageVote, oldTotalVote), (Object)this.getIdentifier(), averageRatingList);
        try {
            this.saveAverageRating(averageRating);
            this.getObservationManager().notify((Event)new UpdatedAverageRatingEvent(averageRating, oldAverageVote, oldTotalVote), (Object)this.getIdentifier(), averageRatingList);
            return averageRating;
        }
        catch (RatingsException e) {
            this.getObservationManager().notify((Event)new UpdateAverageRatingFailedEvent(averageRating, oldAverageVote, oldTotalVote), (Object)this.getIdentifier(), averageRatingList);
            throw e;
        }
    }

    @Override
    public AverageRating addVote(EntityReference entityReference, int newVote) throws RatingsException {
        AverageRating averageRating = this.getAverageRating(entityReference);
        int oldTotalVote = averageRating.getNbVotes();
        float oldAverageVote = averageRating.getAverageVote();
        averageRating.addRating(newVote);
        return this.updateAverageRating(averageRating, oldAverageVote, oldTotalVote);
    }

    @Override
    public AverageRating removeVote(EntityReference entityReference, int oldVote) throws RatingsException {
        AverageRating averageRating = this.getAverageRating(entityReference);
        int oldTotalVote = averageRating.getNbVotes();
        float oldAverageVote = averageRating.getAverageVote();
        averageRating.removeRating(oldVote);
        return this.updateAverageRating(averageRating, oldAverageVote, oldTotalVote);
    }

    @Override
    public AverageRating updateVote(EntityReference entityReference, int oldVote, int newVote) throws RatingsException {
        AverageRating averageRating = this.getAverageRating(entityReference);
        int oldTotalVote = averageRating.getNbVotes();
        float oldAverageVote = averageRating.getAverageVote();
        averageRating.updateRating(oldVote, newVote);
        return this.updateAverageRating(averageRating, oldAverageVote, oldTotalVote);
    }

    @Override
    public AverageRating resetAverageRating(EntityReference entityReference, float averageVote, int totalVote) throws RatingsException {
        AverageRating averageRating = this.getAverageRating(entityReference);
        int oldTotalVote = averageRating.getNbVotes();
        float oldAverageVote = averageRating.getAverageVote();
        DefaultAverageRating updatedAverageRating = new DefaultAverageRating(averageRating);
        updatedAverageRating.setAverageVote(averageVote);
        updatedAverageRating.setTotalVote(totalVote);
        updatedAverageRating.setUpdatedAt(new Date());
        return this.updateAverageRating(updatedAverageRating, oldAverageVote, oldTotalVote);
    }
}

