/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.RatingsManagerFactory;

@Component
@Singleton
public class DefaultRatingsManagerFactory
implements RatingsManagerFactory {
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private ComponentManager currentComponentManager;

    private RatingsConfiguration getRatingConfiguration(String hint) throws ComponentLookupException {
        RatingsConfiguration result = this.contextComponentManager.hasComponent(RatingsConfiguration.class, hint) ? (RatingsConfiguration)this.contextComponentManager.getInstance(RatingsConfiguration.class, hint) : (RatingsConfiguration)this.contextComponentManager.getInstance(RatingsConfiguration.class);
        return result;
    }

    @Override
    public RatingsManager getRatingsManager(String managerName) throws RatingsException {
        try {
            RatingsManager result;
            if (!this.contextComponentManager.hasComponent(RatingsManager.class, managerName)) {
                RatingsConfiguration ratingsConfiguration = this.getRatingConfiguration(managerName);
                ComponentDescriptor componentDescriptor = this.contextComponentManager.getComponentDescriptor(RatingsManager.class, ratingsConfiguration.getRatingsStorageHint());
                result = (RatingsManager)this.contextComponentManager.getInstance(RatingsManager.class, ratingsConfiguration.getRatingsStorageHint());
                result.setRatingConfiguration(ratingsConfiguration);
                result.setIdentifier(managerName);
                DefaultComponentDescriptor componentDescriptorCopy = new DefaultComponentDescriptor(componentDescriptor);
                componentDescriptorCopy.setRoleHint(managerName);
                componentDescriptorCopy.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
                this.currentComponentManager.registerComponent((ComponentDescriptor)componentDescriptorCopy, (Object)result);
            } else {
                result = (RatingsManager)this.contextComponentManager.getInstance(RatingsManager.class, managerName);
            }
            return result;
        }
        catch (ComponentLookupException | ComponentRepositoryException e) {
            throw new RatingsException(String.format("Error when trying to instantiate Rating Manager with name [%s]", managerName), e);
        }
    }

    @Override
    public List<RatingsManager> getInstantiatedManagers() throws RatingsException {
        ArrayList<RatingsManager> result = new ArrayList<RatingsManager>();
        try {
            List instanceList = this.contextComponentManager.getInstanceList(RatingsManager.class);
            for (RatingsManager ratingsManager : instanceList) {
                if (StringUtils.isEmpty((CharSequence)ratingsManager.getIdentifier())) continue;
                result.add(ratingsManager);
            }
        }
        catch (ComponentLookupException e) {
            throw new RatingsException("Error when trying to get a RatingManager", e);
        }
        return result;
    }
}

