/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.ratings.RatingsConfiguration;

@Component
@Singleton
public class DefaultRatingsConfiguration
implements RatingsConfiguration {
    @Inject
    @Named(value="ratings")
    private ConfigurationSource configurationSource;
    @Inject
    private EntityReferenceResolver<String> entityReferenceResolver;

    @Override
    public boolean isZeroStored() {
        return (Boolean)this.configurationSource.getProperty("zeroStored", (Object)true);
    }

    @Override
    public int getScaleUpperBound() {
        return (Integer)this.configurationSource.getProperty("scaleUpperBound", (Object)5);
    }

    @Override
    public boolean hasDedicatedCore() {
        return (Boolean)this.configurationSource.getProperty("dedicatedCore", (Object)false);
    }

    @Override
    public boolean isAverageStored() {
        return (Boolean)this.configurationSource.getProperty("averageStored", (Object)true);
    }

    @Override
    public String getRatingsStorageHint() {
        return (String)this.configurationSource.getProperty("ratingsStorageHint", (Object)"solr");
    }

    @Override
    public String getAverageRatingStorageHint() {
        return (String)this.configurationSource.getProperty("averageRatingStorageHint", (Object)"xobject");
    }

    @Override
    public Set<EntityReference> getExcludedReferencesFromRatings() {
        Set<EntityReference> result;
        Set serializedExcludedReferences = (Set)this.configurationSource.getProperty("excludedReferences", new HashSet());
        if (serializedExcludedReferences.isEmpty()) {
            result = Collections.emptySet();
        } else {
            result = new HashSet();
            for (String serializedExcludedReference : serializedExcludedReferences) {
                result.add(this.entityReferenceResolver.resolve((Object)serializedExcludedReference, EntityType.PAGE, new Object[0]));
            }
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.configurationSource.getProperty("enabled", (Object)true);
    }
}

