/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.query.QueryParameter;
import org.xwiki.query.SecureQuery;
import org.xwiki.query.internal.ScriptQueryParameter;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptQuery
implements SecureQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptQuery.class);
    private final ComponentManager componentManager;
    private final Query query;
    private boolean switchAuthor;
    private DocumentReference authorReference;
    private DocumentReference sourceReference;

    public ScriptQuery(Query query, ComponentManager cm) {
        this.query = query;
        this.componentManager = cm;
    }

    public Query addFilter(String filter) {
        if (!StringUtils.isBlank((CharSequence)filter)) {
            try {
                QueryFilter queryFilter = (QueryFilter)this.componentManager.getInstance(QueryFilter.class, filter);
                this.addFilter(queryFilter);
            }
            catch (ComponentLookupException e) {
                LOGGER.warn("Failed to load QueryFilter with component hint [{}]. Root error [{}]", (Object)filter, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return this;
    }

    public long count() {
        long result = -1L;
        try {
            QueryManager queryManager = (QueryManager)this.componentManager.getInstance(QueryManager.class);
            Query countQuery = queryManager.createQuery(this.getStatement(), this.getLanguage());
            countQuery.setWiki(this.getWiki());
            for (Map.Entry<Integer, Object> entry : this.getPositionalParameters().entrySet()) {
                countQuery.bindValue(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : this.getNamedParameters().entrySet()) {
                countQuery.bindValue((String)entry.getKey(), entry.getValue());
            }
            for (QueryFilter queryFilter : this.getFilters()) {
                countQuery.addFilter(queryFilter);
            }
            countQuery.addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "count"));
            List results = countQuery.execute();
            result = (Long)results.get(0);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create count query for query [{}]. Root error: [{}]", (Object)this.getStatement(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return result;
    }

    @Override
    public String getStatement() {
        return this.query.getStatement();
    }

    @Override
    public String getLanguage() {
        return this.query.getLanguage();
    }

    @Override
    public boolean isNamed() {
        return this.query.isNamed();
    }

    @Override
    public Query setWiki(String wiki) {
        this.query.setWiki(wiki);
        return this;
    }

    @Override
    public String getWiki() {
        return this.query.getWiki();
    }

    @Override
    public Query bindValue(String variable, Object val) {
        this.query.bindValue(variable, val);
        return this;
    }

    @Override
    public Query bindValue(int index, Object val) {
        this.query.bindValue(index, val);
        return this;
    }

    @Override
    public Query bindValues(List<Object> values) {
        this.query.bindValues(values);
        return this;
    }

    @Override
    public Query bindValues(Map<String, ?> values) {
        this.query.bindValues(values);
        return this;
    }

    @Override
    public QueryParameter bindValue(String variable) {
        QueryParameter parameter = this.query.bindValue(variable);
        return new ScriptQueryParameter(this, parameter);
    }

    @Override
    public Map<String, Object> getNamedParameters() {
        return this.query.getNamedParameters();
    }

    @Override
    public Map<Integer, Object> getPositionalParameters() {
        return this.query.getPositionalParameters();
    }

    @Override
    public Query addFilter(QueryFilter filter) {
        this.query.addFilter(filter);
        return this;
    }

    @Override
    public List<QueryFilter> getFilters() {
        return this.query.getFilters();
    }

    @Override
    public Query setLimit(int limit) {
        this.query.setLimit(limit);
        return this;
    }

    @Override
    public Query setOffset(int offset) {
        this.query.setOffset(offset);
        return this;
    }

    @Override
    public int getLimit() {
        return this.query.getLimit();
    }

    @Override
    public int getOffset() {
        return this.query.getOffset();
    }

    @Override
    public <T> List<T> execute() throws QueryException {
        if (this.switchAuthor) {
            try {
                AuthorExecutor authorExecutor = (AuthorExecutor)this.componentManager.getInstance(AuthorExecutor.class);
                return (List)authorExecutor.call(this.query::execute, this.authorReference, this.sourceReference);
            }
            catch (QueryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QueryException("Failed to execute query", this.query, e);
            }
        }
        return this.query.execute();
    }

    @Override
    public boolean isCurrentAuthorChecked() {
        return this.query instanceof SecureQuery ? ((SecureQuery)this.query).isCurrentAuthorChecked() : true;
    }

    public SecureQuery setQueryAuthor(DocumentReference authorReference, DocumentReference sourceReference) throws AccessDeniedException {
        if (this.query instanceof SecureQuery) {
            try {
                ContextualAuthorizationManager authorization = (ContextualAuthorizationManager)this.componentManager.getInstance(ContextualAuthorizationManager.class);
                authorization.checkAccess(Right.PROGRAM);
                this.switchAuthor = true;
                this.authorReference = authorReference;
                this.sourceReference = sourceReference;
            }
            catch (ComponentLookupException e) {
                LOGGER.error("Failed to lookup authorization manager", (Throwable)e);
            }
        }
        return this;
    }

    @Override
    public SecureQuery checkCurrentAuthor(boolean checkCurrentAuthor) {
        return this;
    }

    @Override
    public boolean isCurrentUserChecked() {
        return this.query instanceof SecureQuery ? ((SecureQuery)this.query).isCurrentAuthorChecked() : false;
    }

    @Override
    public SecureQuery checkCurrentUser(boolean checkCurrentUser) {
        if (this.query instanceof SecureQuery) {
            ((SecureQuery)this.query).isCurrentAuthorChecked();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptQuery that = (ScriptQuery)o;
        return new EqualsBuilder().append(this.switchAuthor, that.switchAuthor).append((Object)this.componentManager, (Object)that.componentManager).append((Object)this.query, (Object)that.query).append((Object)this.authorReference, (Object)that.authorReference).append((Object)this.sourceReference, (Object)that.sourceReference).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.componentManager).append((Object)this.query).append(this.switchAuthor).append((Object)this.authorReference).append((Object)this.sourceReference).toHashCode();
    }
}

