/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryExecutorManager;

@Component(roles={QueryExecutorManager.class})
@Singleton
public class DefaultQueryExecutorManager
implements QueryExecutorManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Provider<QueryExecutor> namedQueryExecutorProvider;

    @Override
    public <T> List<T> execute(Query query) throws QueryException {
        if (query.isNamed()) {
            return ((QueryExecutor)this.namedQueryExecutorProvider.get()).execute(query);
        }
        try {
            return ((QueryExecutor)((ComponentManager)this.componentManagerProvider.get()).getInstance(QueryExecutor.class, query.getLanguage())).execute(query);
        }
        catch (ComponentLookupException e) {
            throw new QueryException("Fail to lookup query executor", query, e);
        }
    }

    @Override
    public Set<String> getLanguages() {
        List executors = ((ComponentManager)this.componentManagerProvider.get()).getComponentDescriptorList(QueryExecutor.class);
        HashSet<String> executorNames = new HashSet<String>(executors.size());
        for (ComponentDescriptor executor : executors) {
            executorNames.add(executor.getRoleHint());
        }
        return executorNames;
    }
}

