/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.observation.remote.RemoteObservationManagerConfiguration;

@Component
@Singleton
public class DefaultRemoteObservationManagerConfiguration
implements RemoteObservationManagerConfiguration,
Initializable {
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;
    @Inject
    private Environment environment;
    private String id;

    @Override
    public boolean isEnabled() {
        Boolean enabled = (Boolean)this.configurationSource.getProperty("observation.remote.enabled", Boolean.class);
        return enabled != null ? enabled : false;
    }

    @Override
    public List<String> getChannels() {
        List channels = (List)this.configurationSource.getProperty("observation.remote.channels", List.class);
        return channels == null ? Collections.emptyList() : channels;
    }

    @Override
    public String getNetworkAdapter() {
        return (String)this.configurationSource.getProperty("observation.remote.networkadapter", (Object)"jgroups");
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void initialize() throws InitializationException {
        Path observation = this.getObservationDirectory();
        observation.toFile().mkdirs();
        Path idFile = this.getIdFile();
        if (!Files.exists(idFile, new LinkOption[0])) {
            try {
                String idString = UUID.randomUUID().toString();
                Files.writeString(idFile, (CharSequence)idString, new OpenOption[0]);
                this.id = idString;
            }
            catch (IOException e) {
                throw new InitializationException(String.format("Failed to create observation id file [%s]", idFile), (Throwable)e);
            }
        }
        try {
            this.id = Files.readString(idFile);
        }
        catch (IOException e) {
            throw new InitializationException(String.format("Failed to read the observation id file [%s]", idFile), (Throwable)e);
        }
    }

    private Path getIdFile() {
        return this.getObservationDirectory().resolve("id.txt");
    }

    private Path getObservationDirectory() {
        return this.environment.getPermanentDirectory().toPath().resolve("observation");
    }
}

