import { displayerMixin as y, XWikiIcon as h, BaseDisplayer as u } from "xwiki-livedata";
import { resolveComponent as l, createBlock as f, openBlock as m, withCtx as p, createElementVNode as d, withDirectives as b, createVNode as g, vShow as k } from "vue";
import { _ as D } from "./_plugin-vue_export-helper-CHgC5LLL.js";
const _ = {
  name: "displayer-toggle",
  components: { BaseDisplayer: u, XWikiIcon: h },
  // Add the displayerMixin to get access to all the displayers methods and computed properties inside this component.
  mixins: [y],
  inject: ["jQuery"],
  props: {
    iconName: {
      type: String,
      default: "bell"
    }
  },
  data() {
    return {
      // When this value changes to true following the ready from XWikiIcon, the toggle is initialized.
      iconReady: !1,
      innerChecked: this.entry[`${this.propertyId}_checked`],
      innerDisabled: this.entry[`${this.propertyId}_disabled`],
      innerData: {
        ...this.entry[`${this.propertyId}_data`]
      }
    };
  },
  watch: {
    iconReady: function(t) {
      if (t) {
        const e = this;
        this.$nextTick(() => {
          require(["xwiki-bootstrap-switch"], () => {
            this.jQuery(this.$refs.input).bootstrapSwitch({
              size: "mini",
              state: e.innerChecked,
              disabled: e.innerDisabled,
              labelText: this.$refs.icon.$el.outerHTML,
              /*
               Send a xwiki:livedata:toggle event with the following event data:
               - the data of the toggle
               - the new state of the toggle
               - the disabled status of the toggle
               - a callback. When the callback is called, the toggle component is updated with the provided data, state,
                  and disabled status.
              */
              onSwitchChange(c, r) {
                const i = e.innerData, o = e.innerDisabled;
                e.logic.triggerEvent("toggle", {
                  data: i,
                  checked: r,
                  disabled: o,
                  callback: function({
                    data: s = i,
                    checked: n = r,
                    disabled: a = o
                  }) {
                    e.innerData = s, e.innerChecked = n, e.innerDisabled = a, this.jQuery(e.$refs.input).bootstrapSwitch("state", n, !0), this.jQuery(e.$refs.input).bootstrapSwitch("disabled", a);
                  }
                });
              }
            });
          });
        });
      }
    }
  }
}, w = {
  type: "checkbox",
  class: "toggleableFilterPreferenceCheckbox",
  ref: "input"
};
function $(t, e, c, r, i, o) {
  const s = l("XWikiIcon"), n = l("BaseDisplayer");
  return m(), f(n, {
    class: "displayer-toggle",
    "view-only": "",
    "property-id": t.propertyId,
    entry: t.entry,
    "is-empty": !1,
    "intercept-touch": !1
  }, {
    viewer: p(() => [
      d("input", w, null, 512),
      b(d("span", null, [
        g(s, {
          "icon-descriptor": { name: c.iconName },
          ref: "icon",
          onReady: e[0] || (e[0] = (a) => i.iconReady = !0)
        }, null, 8, ["icon-descriptor"])
      ], 512), [
        [k, !1]
      ])
    ]),
    editor: p(() => e[1] || (e[1] = [])),
    _: 1
  }, 8, ["property-id", "entry"]);
}
const I = /* @__PURE__ */ D(_, [["render", $]]);
export {
  I as default
};
//# sourceMappingURL=DisplayerToggle-Dzzk8ZgT.js.map
