/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.script;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.notifications.sources.internal.DefaultNotificationParametersFactory;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="notification.sources")
@Singleton
public class NotificationSourcesScriptService
implements ScriptService {
    @Inject
    private ParametrizedNotificationManager notificationManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DefaultNotificationParametersFactory notificationParametersFactory;

    public List<CompositeEvent> getEvents(int expectedCount) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentAccessBridge.getCurrentUserReference();
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = expectedCount;
        parameters.endDateIncluded = true;
        this.notificationParametersFactory.useUserPreferences(parameters);
        return this.notificationManager.getEvents(parameters);
    }

    public List<CompositeEvent> getEvents(int expectedCount, Date untilDate, String[] blackList) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentAccessBridge.getCurrentUserReference();
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = expectedCount;
        parameters.endDate = untilDate;
        parameters.endDateIncluded = true;
        parameters.blackList = Arrays.asList(blackList);
        this.notificationParametersFactory.useUserPreferences(parameters);
        return this.notificationManager.getEvents(parameters);
    }

    public List<CompositeEvent> getEvents(int expectedCount, Date untilDate, List<String> blackList) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentAccessBridge.getCurrentUserReference();
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = expectedCount;
        parameters.endDate = untilDate;
        parameters.endDateIncluded = true;
        parameters.blackList = blackList;
        this.notificationParametersFactory.useUserPreferences(parameters);
        return this.notificationManager.getEvents(parameters);
    }

    public long getEventsCount(int maxCount) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.documentAccessBridge.getCurrentUserReference();
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = maxCount;
        parameters.onlyUnread = true;
        return this.notificationManager.getEvents(parameters).size();
    }

    public NotificationParameters getNotificationParameters(Map<String, String> parameters) throws NotificationException {
        return this.notificationParametersFactory.createNotificationParametersWithStringMap(parameters);
    }
}

