/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.sources.internal.TagNotificationFilterPreference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
@Named(value="Tag Notification Filter")
public class TagNotificationFilter
implements NotificationFilter {
    public static final String NAME = "Tag Notification Filter";
    @Inject
    private QueryManager queryManager;
    @Inject
    private Logger logger;

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return NotificationFilter.FilterPolicy.NO_EFFECT;
    }

    public boolean matchesPreference(NotificationPreference preference) {
        return false;
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        if (type == NotificationFilterType.INCLUSIVE) {
            return null;
        }
        List enabledTags = filterPreferences.stream().filter(nfp -> nfp instanceof TagNotificationFilterPreference && nfp.isEnabled()).map(nfp -> ((TagNotificationFilterPreference)nfp).getTag().toLowerCase()).collect(Collectors.toList());
        if (enabledTags.isEmpty()) {
            return null;
        }
        try {
            String currentWiki = this.findCurrentWiki(filterPreferences);
            if (currentWiki == null) {
                this.logger.warn("The current wiki shouldn't be null in the TagNotificationFilter.");
                return null;
            }
            Query query = this.queryManager.createQuery("SELECT DISTINCT doc.fullName FROM XWikiDocument doc, BaseObject obj, DBStringListProperty tags JOIN tags.list AS item WHERE obj.name = doc.fullName AND obj.className = 'XWiki.TagClass' AND obj.id = tags.id.id AND tags.id.name = 'tags' AND lower(item) IN (:tagList)", "hql");
            query.bindValue("tagList", enabledTags);
            query.setWiki(currentWiki);
            List pagesHoldingTags = query.execute();
            return ExpressionBuilder.value((EventProperty)EventProperty.PAGE).inStrings((Collection)pagesHoldingTags).and((AbstractOperatorNode)ExpressionBuilder.value((EventProperty)EventProperty.WIKI).eq((AbstractValueNode)ExpressionBuilder.value((String)currentWiki)));
        }
        catch (QueryException e) {
            this.logger.warn("Failed to get the list of documents holding some tags.", (Throwable)e);
            return null;
        }
    }

    private String findCurrentWiki(Collection<NotificationFilterPreference> filterPreferences) {
        for (NotificationFilterPreference nfp : filterPreferences) {
            if (!nfp.isEnabled() || !(nfp instanceof TagNotificationFilterPreference)) continue;
            TagNotificationFilterPreference pref = (TagNotificationFilterPreference)nfp;
            return pref.getCurrentWiki();
        }
        return null;
    }

    public String getName() {
        return NAME;
    }
}

