/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.text.CaseUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterProperty;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.status.ForUserEventFilter;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.internal.InternalNotificationPreference;
import org.xwiki.notifications.sources.internal.TagNotificationFilterPreference;
import org.xwiki.notifications.sources.internal.UsersParameterHandler;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={DefaultNotificationParametersFactory.class})
@Singleton
public class DefaultNotificationParametersFactory {
    private static final String FIELD_SEPARATOR = ",";
    @Inject
    private DocumentReferenceResolver<String> stringDocumentReferenceResolver;
    @Inject
    private EntityReferenceResolver<String> entityReferenceResolver;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeEntityReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private UsersParameterHandler usersParameterHandler;
    @Inject
    private Logger logger;
    @Inject
    protected NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    protected NotificationFilterManager notificationFilterManager;
    @Inject
    protected NotificationFilterPreferenceManager notificationFilterPreferenceManager;

    public NotificationParameters createNotificationParametersWithStringMap(Map<String, String> parameters) throws NotificationException {
        HashMap<ParametersKey, String> keyStringMap = new HashMap<ParametersKey, String>();
        for (Map.Entry<String, String> parameterPair : parameters.entrySet()) {
            String parameterKey = parameterPair.getKey();
            String parameterValue = parameterPair.getValue();
            ParametersKey actualKey = ParametersKey.valueOfIgnoreCase(parameterKey);
            if (actualKey != null) {
                keyStringMap.put(actualKey, parameterValue);
                continue;
            }
            this.logger.error("Cannot find the right parameter key for name [{}].", (Object)parameterKey);
        }
        return this.createNotificationParameters(keyStringMap);
    }

    public NotificationParameters createNotificationParameters(Map<ParametersKey, String> parameters) throws NotificationException {
        NotificationParameters notificationParameters = new NotificationParameters();
        block11: for (Map.Entry<ParametersKey, String> parameterPair : parameters.entrySet()) {
            ParametersKey actualKey = parameterPair.getKey();
            String parameterValue = parameterPair.getValue();
            if (!actualKey.isDirectlyUsed()) continue;
            switch (actualKey) {
                case FORMAT: {
                    this.handleFormat(notificationParameters, parameterValue);
                    continue block11;
                }
                case USER_ID: {
                    this.handleUserId(notificationParameters, parameterValue);
                    continue block11;
                }
                case UNTIL_DATE: {
                    this.handleUntilDate(notificationParameters, parameterValue, BooleanUtils.toBooleanObject((String)parameters.get((Object)ParametersKey.UNTIL_DATE_INCLUDED)) != Boolean.FALSE);
                    continue block11;
                }
                case BLACKLIST: {
                    this.handleBlacklist(notificationParameters, parameterValue);
                    continue block11;
                }
                case MAX_COUNT: {
                    this.handleMaxCount(notificationParameters, parameterValue);
                    continue block11;
                }
                case ONLY_UNREAD: {
                    this.handleOnlyUnread(notificationParameters, parameterValue);
                    continue block11;
                }
                case NOTIFICATION_GROUPING_EVENT_TARGET: {
                    notificationParameters.groupingEventTarget = parameterValue;
                    continue block11;
                }
            }
            this.logger.error("The notification parameters key [{}] exist but has not been implemented.", (Object)actualKey.name());
        }
        if (notificationParameters.format == null) {
            notificationParameters.format = NotificationFormat.ALERT;
        }
        try {
            if (Boolean.parseBoolean(parameters.get((Object)ParametersKey.USE_USER_PREFERENCES))) {
                this.useUserPreferences(notificationParameters);
            } else {
                this.dontUseUserPreferences(notificationParameters, parameters);
            }
        }
        catch (EventStreamException e) {
            throw new NotificationException("Error while adding the filters to the notification parameters.", (Throwable)e);
        }
        return notificationParameters;
    }

    public void useUserPreferences(NotificationParameters parameters) throws NotificationException {
        if (parameters.user != null) {
            parameters.filters = new HashSet<NotificationFilter>(this.notificationFilterManager.getAllFilters(parameters.user, true, NotificationFilter.FilteringPhase.POST_FILTERING));
            this.enableAllEventTypes(parameters);
            parameters.filters.add((NotificationFilter)new ForUserEventFilter(parameters.format, null));
        }
    }

    public NotificationParameters getParametersForUserAndCount(String userId, int expectedCount) throws NotificationException {
        NotificationParameters parameters = new NotificationParameters();
        parameters.user = this.stringDocumentReferenceResolver.resolve((Object)userId, new Object[0]);
        parameters.format = NotificationFormat.ALERT;
        parameters.expectedCount = expectedCount;
        parameters.endDateIncluded = true;
        this.useUserPreferences(parameters);
        return parameters;
    }

    private void dontUseUserPreferences(NotificationParameters notificationParameters, Map<ParametersKey, String> parameters) throws NotificationException, EventStreamException {
        ArrayList<String> excludedFilters = new ArrayList<String>();
        if (Boolean.parseBoolean(parameters.get((Object)ParametersKey.DISPLAY_OWN_EVENTS))) {
            excludedFilters.add("ownEventsNotificationFilter");
        }
        if (Boolean.parseBoolean(parameters.get((Object)ParametersKey.DISPLAY_MINOR_EVENTS)) && notificationParameters.format == NotificationFormat.ALERT) {
            excludedFilters.add("minorEventAlertNotificationFilter");
        }
        if (Boolean.parseBoolean(parameters.get((Object)ParametersKey.DISPLAY_SYSTEM_EVENTS))) {
            excludedFilters.add("systemUserNotificationFilter");
        }
        if (Boolean.parseBoolean(parameters.get((Object)ParametersKey.DISPLAY_READ_EVENTS)) && notificationParameters.format == NotificationFormat.ALERT) {
            excludedFilters.add("eventReadAlertFilter");
        }
        this.enableAllEventTypes(notificationParameters);
        String wikis = parameters.get((Object)ParametersKey.WIKIS);
        String pages = parameters.get((Object)ParametersKey.PAGES);
        String spaces = parameters.get((Object)ParametersKey.SPACES);
        boolean noLocationFilter = StringUtils.isBlank((CharSequence)wikis) && StringUtils.isBlank((CharSequence)pages) && StringUtils.isBlank((CharSequence)spaces);
        notificationParameters.filters = this.notificationFilterManager.getAllFilters(true).stream().filter(filter -> !excludedFilters.contains(filter.getName()) && (!noLocationFilter || !filter.getName().equals("scopeNotificationFilter"))).collect(Collectors.toSet());
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        String currentWiki = parameters.get((Object)ParametersKey.CURRENT_WIKI);
        if (StringUtils.isEmpty((CharSequence)currentWiki)) {
            currentWiki = currentWikiId;
        }
        this.handleLocationParameter(pages, notificationParameters, NotificationFilterProperty.PAGE, currentWiki);
        this.handleLocationParameter(spaces, notificationParameters, NotificationFilterProperty.SPACE, currentWiki);
        this.handleLocationParameter(wikis, notificationParameters, NotificationFilterProperty.WIKI, currentWiki);
        this.handleSubwikiWithoutLocationParameters(notificationParameters, parameters, currentWiki);
        try {
            this.usersParameterHandler.handleUsersParameter(parameters.get((Object)ParametersKey.USERS), notificationParameters);
        }
        catch (Exception e) {
            throw new NotificationException("Failed to handler users parameter", (Throwable)e);
        }
        this.handleTagsParameter(notificationParameters, parameters.get((Object)ParametersKey.TAGS), currentWiki);
    }

    private void handleTagsParameter(NotificationParameters parameters, String tags, String currentWiki) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            String[] tagArray = tags.split(FIELD_SEPARATOR);
            for (int i = 0; i < tagArray.length; ++i) {
                parameters.filterPreferences.add(new TagNotificationFilterPreference(tagArray[i], currentWiki));
            }
        }
    }

    private void handleSubwikiWithoutLocationParameters(NotificationParameters notificationParameters, Map<ParametersKey, String> parameters, String currentWiki) {
        if (StringUtils.isBlank((CharSequence)parameters.get((Object)ParametersKey.WIKIS)) && StringUtils.isBlank((CharSequence)parameters.get((Object)ParametersKey.PAGES)) && StringUtils.isBlank((CharSequence)parameters.get((Object)ParametersKey.SPACES)) && !Strings.CS.equals(currentWiki, this.wikiDescriptorManager.getMainWikiId())) {
            this.handleLocationParameter(currentWiki, notificationParameters, NotificationFilterProperty.WIKI, currentWiki);
        }
    }

    private void handleLocationParameter(String locations, NotificationParameters parameters, NotificationFilterProperty property, String currentWiki) {
        if (StringUtils.isNotBlank((CharSequence)locations)) {
            HashSet<NotificationFormat> formats = new HashSet<NotificationFormat>();
            formats.add(parameters.format);
            String[] locationArray = locations.split(FIELD_SEPARATOR);
            for (int i = 0; i < locationArray.length; ++i) {
                DefaultNotificationFilterPreference pref = new DefaultNotificationFilterPreference();
                pref.setId(String.format("%s_%s_%s", "scopeNotificationFilter", property, i));
                pref.setEnabled(true);
                pref.setFilterName("scopeNotificationFilter");
                pref.setFilterType(NotificationFilterType.INCLUSIVE);
                pref.setNotificationFormats(formats);
                switch (property) {
                    case WIKI: {
                        pref.setWiki(locationArray[i]);
                        break;
                    }
                    case SPACE: {
                        pref.setPage(this.makeReferenceAbsolute(locationArray[i], EntityType.SPACE, currentWiki));
                        break;
                    }
                    case PAGE: {
                        pref.setPageOnly(this.makeReferenceAbsolute(locationArray[i], EntityType.PAGE, currentWiki));
                        break;
                    }
                }
                parameters.filterPreferences.add((NotificationFilterPreference)new ScopeNotificationFilterPreference((NotificationFilterPreference)pref, this.entityReferenceResolver));
            }
        }
    }

    private String makeReferenceAbsolute(String entityRefStr, EntityType entityType, String currentWiki) {
        EntityReference entityRef = this.relativeEntityReferenceResolver.resolve((Object)entityRefStr, entityType, new Object[0]);
        if (entityRef.extractReference(EntityType.WIKI) == null) {
            entityRef = this.entityReferenceResolver.resolve((Object)entityRefStr, entityType, new Object[]{new EntityReference(currentWiki, EntityType.WIKI)});
        }
        return (String)this.entityReferenceSerializer.serialize(entityRef, new Object[0]);
    }

    protected void enableAllEventTypes(NotificationParameters parameters) throws NotificationException {
        parameters.preferences.clear();
        try {
            for (RecordableEventDescriptor descriptor : this.recordableEventDescriptorManager.getRecordableEventDescriptors(true)) {
                parameters.preferences.add(new InternalNotificationPreference(descriptor));
            }
        }
        catch (EventStreamException e) {
            throw new NotificationException("Failed to get recorabled event descriptors", (Throwable)e);
        }
    }

    private void handleOnlyUnread(NotificationParameters notificationParameters, String onlyUnread) {
        notificationParameters.onlyUnread = Boolean.parseBoolean(onlyUnread);
    }

    private void handleMaxCount(NotificationParameters notificationParameters, String maxCount) {
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            try {
                notificationParameters.expectedCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException e) {
                this.logger.error("Error while parsing maxCount number [{}] the parameter won't be taken into account.", (Object)maxCount, (Object)e);
            }
        }
    }

    private void handleFormat(NotificationParameters notificationParameters, String format) {
        if (StringUtils.isNotBlank((CharSequence)format)) {
            notificationParameters.format = NotificationFormat.valueOf((String)format);
        }
    }

    private void handleUserId(NotificationParameters notificationParameters, String userId) {
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            notificationParameters.user = this.stringDocumentReferenceResolver.resolve((Object)userId, new Object[0]);
        }
    }

    private void handleBlacklist(NotificationParameters notificationParameters, String blackList) {
        if (StringUtils.isNotBlank((CharSequence)blackList)) {
            notificationParameters.blackList.addAll(Arrays.asList(blackList.split(FIELD_SEPARATOR)));
        }
    }

    private void handleUntilDate(NotificationParameters notificationParameters, String untilDate, boolean untilDateIncluded) {
        if (StringUtils.isNotBlank((CharSequence)untilDate)) {
            notificationParameters.endDate = new Date(Long.parseLong(untilDate));
            notificationParameters.endDateIncluded = untilDateIncluded;
        }
    }

    public static enum ParametersKey {
        FORMAT(true),
        USER_ID(true),
        USE_USER_PREFERENCES(false),
        UNTIL_DATE(true),
        UNTIL_DATE_INCLUDED(false),
        BLACKLIST(true),
        MAX_COUNT(true),
        ONLY_UNREAD(true),
        PAGES(false),
        SPACES(false),
        WIKIS(false),
        USERS(false),
        DISPLAY_OWN_EVENTS(false),
        DISPLAY_MINOR_EVENTS(false),
        DISPLAY_SYSTEM_EVENTS(false),
        DISPLAY_READ_EVENTS(false),
        TAGS(false),
        CURRENT_WIKI(false),
        NOTIFICATION_GROUPING_EVENT_TARGET(true);

        private boolean isDirectlyUsed;

        private ParametersKey(boolean isDirectlyUsed) {
            this.isDirectlyUsed = isDirectlyUsed;
        }

        protected boolean isDirectlyUsed() {
            return this.isDirectlyUsed;
        }

        static ParametersKey valueOfIgnoreCase(String name) {
            for (ParametersKey key : ParametersKey.values()) {
                if (!CaseUtils.toCamelCase((String)key.name(), (boolean)false, (char[])new char[]{'_'}).equalsIgnoreCase(CaseUtils.toCamelCase((String)name, (boolean)false, (char[])new char[]{'_'}))) continue;
                return key;
            }
            try {
                return ParametersKey.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

