/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.Event;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.GroupingEventManager;
import org.xwiki.notifications.GroupingEventStrategy;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.user.UserReference;

@Component
@Singleton
public class DefaultGroupingEventManager
implements GroupingEventManager {
    @Inject
    private GroupingEventStrategy defaultGroupingEventStrategy;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public List<CompositeEvent> getCompositeEvents(List<Event> events, UserReference userReference, String target) throws NotificationException {
        return this.getStrategy(userReference, target).group(events);
    }

    public void augmentCompositeEvents(List<CompositeEvent> compositeEvents, List<Event> newEvents, UserReference userReference, String target) throws NotificationException {
        this.getStrategy(userReference, target).group(compositeEvents, newEvents);
    }

    private GroupingEventStrategy getStrategy(UserReference userReference, String target) throws NotificationException {
        GroupingEventStrategy groupingEventStrategy = this.defaultGroupingEventStrategy;
        if (userReference != null) {
            String strategyHint = this.notificationPreferenceManager.getNotificationGroupingStrategy(userReference, target);
            if (this.componentManager.hasComponent(GroupingEventStrategy.class, strategyHint)) {
                try {
                    groupingEventStrategy = (GroupingEventStrategy)this.componentManager.getInstance(GroupingEventStrategy.class, strategyHint);
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Error when getting grouping event strategy instance with hint [{}]. It will fallback on default strategy. Root cause: [{}].", (Object)strategyHint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            } else {
                this.logger.warn("No grouping event strategy found with hint [{}]. It will fallback on default strategy.", (Object)strategyHint);
            }
        }
        return groupingEventStrategy;
    }
}

