/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.script;

import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.CompositeEventStatus;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.script.internal.NotificationScriptEventHelper;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;

@Component
@Singleton
@Named(value="notification")
public class NotificationScriptService
implements ScriptService {
    public static final String ROLE_HINT = "notification";
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    private NotificationScriptEventHelper notificationScriptEventHelper;
    @Inject
    private ScriptServiceManager scriptServiceManager;

    public ScriptService get(String serviceName) {
        return this.scriptServiceManager.get("notification." + serviceName);
    }

    public List<EventStatus> getEventStatuses(List<Event> events) throws Exception {
        return this.notificationScriptEventHelper.getEventStatuses(events);
    }

    public List<CompositeEventStatus> getCompositeEventStatuses(List<CompositeEvent> compositeEvents) throws Exception {
        return this.notificationScriptEventHelper.getCompositeEventStatuses(compositeEvents);
    }

    public boolean isEnabled() {
        return this.notificationConfiguration.isEnabled();
    }

    public boolean areEmailsEnabled() {
        return this.notificationConfiguration.areEmailsEnabled();
    }

    public void saveEventStatus(String eventId, boolean isRead) throws Exception {
        this.notificationScriptEventHelper.saveEventStatus(eventId, isRead);
    }

    public void clearAllStatus(Date startDate) throws Exception {
        this.notificationScriptEventHelper.clearAllStatus(startDate);
    }
}

