/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.rest.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.filters.watch.WatchedEntitiesManager;
import org.xwiki.notifications.filters.watch.WatchedEntityFactory;
import org.xwiki.notifications.filters.watch.WatchedEntityReference;
import org.xwiki.notifications.filters.watch.WatchedLocationReference;
import org.xwiki.notifications.rest.NotificationsWatchResource;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="org.xwiki.notifications.rest.internal.DefaultNotificationsWatchResource")
public class DefaultNotificationsWatchResource
extends XWikiResource
implements NotificationsWatchResource {
    private static final String GUEST_USER_ERROR_MESSAGE = "Only logged-in users can access this.";
    @Inject
    private WatchedEntitiesManager watchedEntitiesManager;
    @Inject
    private WatchedEntityFactory watchedEntityFactory;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;

    private EntityReference getEntityReference(String wikiName, String spaceNames, String pageName) throws XWikiRestException {
        Object entityReference;
        if (StringUtils.isEmpty((CharSequence)wikiName)) {
            throw new IllegalArgumentException(String.format("wikiName must be not null. Current value: [%s]", wikiName));
        }
        if (!StringUtils.isEmpty((CharSequence)spaceNames)) {
            List spaces = this.parseSpaceSegments(spaceNames.substring("/spaces/".length()));
            entityReference = !StringUtils.isEmpty((CharSequence)pageName) ? new DocumentReference(wikiName, spaces, pageName.substring("/pages/".length())) : new SpaceReference(wikiName, spaces);
        } else {
            entityReference = new WikiReference(wikiName);
        }
        return entityReference;
    }

    @Override
    public Response getPageWatchStatus(String wikiName, String spaceNames, String pageName) throws Exception {
        UserReference user = this.getUser();
        if (user == GuestUserReference.INSTANCE) {
            return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)GUEST_USER_ERROR_MESSAGE).build();
        }
        EntityReference entityReference = this.getEntityReference(wikiName, spaceNames, pageName);
        WatchedLocationReference watchedLocationReference = this.watchedEntityFactory.createWatchedLocationReference(entityReference);
        WatchedEntityReference.WatchedStatus watchedStatus = watchedLocationReference.getWatchedStatus(user);
        return Response.ok((Object)watchedStatus).build();
    }

    private UserReference getUser() {
        return this.userReferenceResolver.resolve((Object)this.getXWikiContext().getUserReference(), new Object[0]);
    }

    private Response watchLocation(EntityReference location, boolean ignore) throws Exception {
        UserReference user = this.getUser();
        if (user == GuestUserReference.INSTANCE) {
            return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)GUEST_USER_ERROR_MESSAGE).build();
        }
        WatchedLocationReference watchedLocationReference = this.watchedEntityFactory.createWatchedLocationReference(location);
        boolean result = ignore ? this.watchedEntitiesManager.block((WatchedEntityReference)watchedLocationReference, this.getUser()) : this.watchedEntitiesManager.watch((WatchedEntityReference)watchedLocationReference, this.getUser());
        return Response.ok((Object)result).build();
    }

    @Override
    public Response watchPage(String wikiName, String spaceNames, String pageName, boolean ignore) throws Exception {
        EntityReference entityReference = this.getEntityReference(wikiName, spaceNames, pageName);
        return this.watchLocation(entityReference, ignore);
    }

    private Response unwatchLocation(EntityReference location) throws Exception {
        UserReference user = this.getUser();
        if (user == GuestUserReference.INSTANCE) {
            return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)GUEST_USER_ERROR_MESSAGE).build();
        }
        WatchedLocationReference watchedLocationReference = this.watchedEntityFactory.createWatchedLocationReference(location);
        boolean result = this.watchedEntitiesManager.removeWatchFilter((WatchedEntityReference)watchedLocationReference, user);
        return Response.ok((Object)result).build();
    }

    @Override
    public Response unwatchPage(String wikiName, String spaceNames, String pageName) throws Exception {
        EntityReference entityReference = this.getEntityReference(wikiName, spaceNames, pageName);
        return this.unwatchLocation(entityReference);
    }
}

