/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.rest.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.internal.DefaultNotificationCacheManager;
import org.xwiki.notifications.rest.NotificationsResource;
import org.xwiki.notifications.rest.internal.InternalNotificationsRenderer;
import org.xwiki.notifications.rest.internal.NotificationEventExecutor;
import org.xwiki.notifications.rest.internal.RSSFeedRenderer;
import org.xwiki.notifications.rest.model.Notifications;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.notifications.sources.internal.DefaultNotificationParametersFactory;
import org.xwiki.rest.XWikiResource;

@Component
@Named(value="org.xwiki.notifications.rest.internal.DefaultNotificationsResource")
public class DefaultNotificationsResource
extends XWikiResource
implements NotificationsResource {
    private static final String TRUE = "true";
    private static final String ASYNC_ID = "asyncId";
    @Inject
    private ParametrizedNotificationManager newNotificationManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private InternalNotificationsRenderer notificationsRenderer;
    @Inject
    private DefaultNotificationCacheManager cacheManager;
    @Inject
    private NotificationEventExecutor executor;
    @Inject
    private DefaultNotificationParametersFactory notificationParametersFactory;
    @Inject
    private RSSFeedRenderer rssFeedRenderer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getNotifications(String useUserPreferences, String userId, String untilDate, boolean untilDateIncluded, String blackList, String pages, String spaces, String wikis, String users, String maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki, String async, String asyncId, String target) throws Exception {
        Response.ResponseBuilder response;
        Object result = this.getCompositeEvents(useUserPreferences, userId, untilDate, untilDateIncluded, blackList, pages, spaces, wikis, users, this.toMaxCount(maxCount, 21), displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, async, asyncId, false, false);
        if (result instanceof String) {
            response = Response.status((Response.Status)Response.Status.ACCEPTED);
            response.entity(Collections.singletonMap(ASYNC_ID, result));
        } else {
            XWikiContext xcontext = this.getXWikiContext();
            xcontext.setURLFactory(xcontext.getWiki().getURLFactoryService().createURLFactory(0, xcontext));
            String currentOriginalWiki = xcontext.getOriginalWikiId();
            try {
                if (currentWiki != null) {
                    xcontext.setOriginalWikiId(currentWiki);
                }
                Notifications notifications = new Notifications(this.notificationsRenderer.renderNotifications((List)result, userId, TRUE.equals(displayReadStatus)));
                response = Response.ok((Object)notifications);
            }
            finally {
                xcontext.setOriginalWikiId(currentOriginalWiki);
            }
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        response.cacheControl(cacheControl);
        return response.build();
    }

    private int toMaxCount(String maxCount, int defaultMaxCount) {
        return this.validateAndGetLimit(NumberUtils.toInt((String)maxCount, (int)defaultMaxCount));
    }

    private Object getCompositeEvents(String useUserPreferences, String userId, String untilDate, boolean untilDateIncluded, String blackList, String pages, String spaces, String wikis, String users, int maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String tags, String currentWiki, String async, String asyncId, boolean onlyUnread, boolean count) throws Exception {
        Object result = null;
        NotificationParameters notificationParameters = this.getNotificationParameters(useUserPreferences, userId, untilDate, untilDateIncluded, blackList, pages, spaces, wikis, users, maxCount, displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, onlyUnread);
        if (asyncId != null && (result = this.executor.popAsync(asyncId)) == null) {
            result = asyncId;
        }
        if (result == null) {
            String cacheKey = this.cacheManager.createCacheKey(notificationParameters);
            result = this.executor.submit(cacheKey, () -> this.getCompositeEvents(notificationParameters), Boolean.parseBoolean(async), count, true);
        }
        return result;
    }

    private List<CompositeEvent> getCompositeEvents(NotificationParameters notificationParameters) throws NotificationException {
        return this.newNotificationManager.getEvents(notificationParameters);
    }

    @Override
    public Response getNotificationsCount(String useUserPreferences, String userId, String pages, String spaces, String wikis, String users, String maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki, String async, String asyncId) throws Exception {
        Response.ResponseBuilder response;
        XWikiUser xWikiUser = this.getXWikiContext().getWiki().checkAuth(this.getXWikiContext());
        if (!StringUtils.isEmpty((CharSequence)userId) && xWikiUser == null) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        } else {
            Object result = this.getCompositeEvents(useUserPreferences, userId, null, true, null, pages, spaces, wikis, users, this.toMaxCount(maxCount, 21), displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, async, asyncId, true, true);
            if (result instanceof String) {
                response = Response.status((Response.Status)Response.Status.ACCEPTED);
                response.entity(Collections.singletonMap(ASYNC_ID, result));
            } else {
                response = Response.ok(Collections.singletonMap("unread", result));
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            response.cacheControl(cacheControl);
        }
        return response.build();
    }

    @Override
    public String getNotificationsRSS(String useUserPreferences, String userId, String untilDate, String blackList, String pages, String spaces, String wikis, String users, String maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki) throws Exception {
        XWikiUser xWikiUser = this.getXWikiContext().getWiki().checkAuth(this.getXWikiContext());
        DocumentReference userIdDoc = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
        if (xWikiUser == null && !StringUtils.isEmpty((CharSequence)userId) || xWikiUser != null && !userIdDoc.equals((Object)xWikiUser.getUserReference())) {
            this.getXWikiContext().getResponse().sendError(401);
            return null;
        }
        List events = (List)this.getCompositeEvents(useUserPreferences, userId, untilDate, true, blackList, pages, spaces, wikis, users, this.toMaxCount(maxCount, 10), displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, tags, currentWiki, null, null, false, false);
        return this.rssFeedRenderer.render(events);
    }

    @Override
    public Response postNotifications(String useUserPreferences, String userId, String untilDate, boolean untilDateIncluded, String blackList, String pages, String spaces, String wikis, String users, String count, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String displayReadStatus, String tags, String currentWiki, String async, String asyncId, String target) throws Exception {
        return this.getNotifications(useUserPreferences, userId, untilDate, untilDateIncluded, blackList, pages, spaces, wikis, users, count, displayOwnEvents, displayMinorEvents, displaySystemEvents, displayReadEvents, displayReadStatus, tags, currentWiki, async, asyncId, "alert");
    }

    private NotificationParameters getNotificationParameters(String useUserPreferences, String userId, String untilDate, boolean untilDateIncluded, String blackList, String pages, String spaces, String wikis, String users, int maxCount, String displayOwnEvents, String displayMinorEvents, String displaySystemEvents, String displayReadEvents, String tags, String currentWiki, boolean onlyUnread) throws NotificationException {
        HashMap<DefaultNotificationParametersFactory.ParametersKey, String> parametersMap = new HashMap<DefaultNotificationParametersFactory.ParametersKey, String>();
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.USE_USER_PREFERENCES, useUserPreferences);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.USER_ID, userId);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.UNTIL_DATE, untilDate);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.UNTIL_DATE_INCLUDED, String.valueOf(untilDateIncluded));
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.BLACKLIST, blackList);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.PAGES, pages);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.SPACES, spaces);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.WIKIS, wikis);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.USERS, users);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.MAX_COUNT, String.valueOf(maxCount));
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.DISPLAY_OWN_EVENTS, displayOwnEvents);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.DISPLAY_MINOR_EVENTS, displayMinorEvents);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.DISPLAY_SYSTEM_EVENTS, displaySystemEvents);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.DISPLAY_READ_EVENTS, displayReadEvents);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.TAGS, tags);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.CURRENT_WIKI, currentWiki);
        parametersMap.put(DefaultNotificationParametersFactory.ParametersKey.ONLY_UNREAD, String.valueOf(onlyUnread));
        return this.notificationParametersFactory.createNotificationParameters(parametersMap);
    }
}

