/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal.email;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.preferences.NotificationEmailInterval;
import org.xwiki.notifications.preferences.email.NotificationEmailDiffType;
import org.xwiki.notifications.preferences.email.NotificationEmailUserPreferenceManager;
import org.xwiki.notifications.preferences.internal.NotificationEmailGroupingStrategyPreferenceDocumentInitializer;
import org.xwiki.notifications.preferences.internal.NotificationEmailPreferenceDocumentInitializer;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultNotificationEmailUserPreferenceManager
implements NotificationEmailUserPreferenceManager {
    private static final String WIKI_SPACE = "XWiki";
    private static final String NOTIFICATIONS = "Notifications";
    private static final String CODE = "Code";
    private static final LocalDocumentReference GLOBAL_PREFERENCES = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications", "Code"), "NotificationAdministration");
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentUserSerializer;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    private Logger logger;

    public NotificationEmailDiffType getDiffType() {
        return this.getDiffType((UserReference)CurrentUserReference.INSTANCE);
    }

    public NotificationEmailDiffType getDiffType(String userId) {
        return this.getDiffType(this.userReferenceResolver.resolve((Object)userId, new Object[0]));
    }

    public NotificationEmailDiffType getDiffType(UserReference userReference) {
        return this.getStaticListPropertyPreference("diffType", NotificationEmailDiffType.class, NotificationEmailDiffType.STANDARD, userReference);
    }

    public NotificationEmailInterval getInterval() {
        return this.getInterval((UserReference)CurrentUserReference.INSTANCE);
    }

    public NotificationEmailInterval getInterval(UserReference userReference) {
        return this.getStaticListPropertyPreference("interval", NotificationEmailInterval.class, NotificationEmailInterval.DAILY, userReference);
    }

    public String getEmailGroupingStrategy(UserReference userReference, NotificationEmailInterval interval) {
        DocumentReference userDocumentReference = (DocumentReference)this.documentUserSerializer.serialize(userReference);
        String result = this.getEmailGroupingStrategyFromDocument(userDocumentReference, interval);
        if (StringUtils.isEmpty((CharSequence)result)) {
            DocumentReference xwikiPref = new DocumentReference(GLOBAL_PREFERENCES, userDocumentReference.getWikiReference());
            result = this.getEmailGroupingStrategyFromDocument(xwikiPref, interval);
        }
        WikiReference mainWikiReference = new WikiReference(this.wikiDescriptorManager.getMainWikiId());
        if (StringUtils.isEmpty((CharSequence)result) && !userDocumentReference.getWikiReference().equals((Object)mainWikiReference)) {
            DocumentReference xwikiPref = new DocumentReference(GLOBAL_PREFERENCES, mainWikiReference);
            result = this.getEmailGroupingStrategyFromDocument(xwikiPref, interval);
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = this.notificationConfiguration.getEmailGroupingStrategyHint();
        }
        return result;
    }

    private String getEmailGroupingStrategyFromDocument(DocumentReference documentReference, NotificationEmailInterval interval) {
        DocumentReference xClassReference = new DocumentReference(NotificationEmailGroupingStrategyPreferenceDocumentInitializer.REFERENCE, documentReference.getWikiReference());
        try {
            XWikiDocument userDocument = (XWikiDocument)this.documentAccessBridge.getDocumentInstance(documentReference);
            List objects = userDocument.getXObjects(xClassReference);
            for (BaseObject object : objects) {
                if (object == null || !StringUtils.equalsIgnoreCase((CharSequence)interval.name(), (CharSequence)object.getStringValue("interval"))) continue;
                return object.getStringValue("strategy");
            }
        }
        catch (Exception e) {
            this.logger.error("Error while accessing document [{}] for reading email grouping strategy for interval [{}].", new Object[]{documentReference, interval, e});
        }
        return null;
    }

    private <T extends Enum<T>> T getStaticListPropertyPreference(String propertyName, Class<T> propertyEnum, T propertyDefaultValue, UserReference user) {
        T returnValue = propertyDefaultValue;
        try {
            DocumentReference userDocumentReference = (DocumentReference)this.documentUserSerializer.serialize(user);
            DocumentReference emailClassReference = new DocumentReference(NotificationEmailPreferenceDocumentInitializer.REFERENCE, userDocumentReference.getWikiReference());
            Object value = this.documentAccessBridge.getProperty(userDocumentReference, emailClassReference, propertyName);
            if (StringUtils.isNotBlank((CharSequence)((String)value))) {
                returnValue = Enum.valueOf(propertyEnum, ((String)value).toUpperCase());
            } else {
                T propertyValue = this.getWikiPreference(userDocumentReference, propertyEnum, propertyName);
                if (propertyValue != null) {
                    returnValue = propertyValue;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the email property [{}] for the user [{}].", new Object[]{propertyName, user, e});
        }
        return returnValue;
    }

    private <T extends Enum<T>> T getWikiPreference(DocumentReference userDocumentReference, Class<T> propertyEnum, String propertyName) {
        T returnValue = null;
        DocumentReference emailClassReference = new DocumentReference(NotificationEmailPreferenceDocumentInitializer.REFERENCE, userDocumentReference.getWikiReference());
        DocumentReference xwikiPref = new DocumentReference(GLOBAL_PREFERENCES, userDocumentReference.getWikiReference());
        Object value = this.documentAccessBridge.getProperty(xwikiPref, emailClassReference, propertyName);
        if (StringUtils.isNotBlank((CharSequence)((String)value))) {
            returnValue = Enum.valueOf(propertyEnum, ((String)value).toUpperCase());
        } else {
            WikiReference mainWiki = new WikiReference(this.wikiDescriptorManager.getMainWikiId());
            if (!userDocumentReference.getWikiReference().equals((Object)mainWiki) && StringUtils.isNotBlank((CharSequence)((String)(value = this.documentAccessBridge.getProperty(xwikiPref = new DocumentReference(GLOBAL_PREFERENCES, mainWiki), emailClassReference = new DocumentReference(NotificationEmailPreferenceDocumentInitializer.REFERENCE, mainWiki), propertyName))))) {
                returnValue = Enum.valueOf(propertyEnum, ((String)value).toUpperCase());
            }
        }
        return returnValue;
    }
}

