/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.management.JMXBeanRegistration;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.preferences.internal.cache.JMXUnboundedEntityCache;
import org.xwiki.notifications.preferences.internal.cache.UnboundedEntityCache;

@Component(roles={UnboundedEntityCacheManager.class})
@Singleton
public class UnboundedEntityCacheManager
implements Disposable {
    private final Map<String, UnboundedEntityCache<?>> caches = new ConcurrentHashMap();
    @Inject
    private JMXBeanRegistration jmx;

    public void dispose() throws ComponentLifecycleException {
        this.caches.values().forEach(c -> this.jmx.unregisterMBean(c.getJmxName()));
    }

    public <T> Map<EntityReference, T> createCache(String name, boolean invalidateOnUpdate) {
        UnboundedEntityCache cache = new UnboundedEntityCache(name, invalidateOnUpdate);
        this.caches.put(cache.getName(), cache);
        this.jmx.registerMBean(new JMXUnboundedEntityCache(cache), cache.getJmxName());
        return cache.getCache();
    }

    public <T> Map<EntityReference, T> getCache(String name) {
        UnboundedEntityCache<?> cache = this.caches.get(name);
        return cache != null ? cache.getCache() : null;
    }

    public void update(DocumentReference entityReference) {
        for (UnboundedEntityCache<?> cache : this.caches.values()) {
            if (!cache.isInvalidateOnUpdate()) continue;
            cache.getCache().remove(entityReference);
        }
    }

    public void remove(DocumentReference entityReference) {
        this.caches.values().forEach(c -> c.getCache().remove(entityReference));
    }

    public void remove(String wikiId) {
        this.caches.values().forEach(c -> this.remove(c.getCache(), wikiId));
    }

    private <T> void remove(Map<EntityReference, T> cache, String wikiId) {
        Iterator<Map.Entry<EntityReference, T>> it = cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<EntityReference, T> entry = it.next();
            if (!entry.getKey().extractReference(EntityType.WIKI).getName().equals(wikiId)) continue;
            it.remove();
        }
    }
}

