/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.internal.NotificationPreferenceModelBridge;
import org.xwiki.notifications.preferences.internal.cache.UnboundedEntityCacheManager;

@Component
@Named(value="cached")
@Singleton
public class CachedNotificationPreferenceModelBridge
implements NotificationPreferenceModelBridge,
Initializable {
    private static final String CACHE_NAME = "NotificationsPreferences";
    private static final String EVENT_GROUPING_CACHE_NAME = "EventGroupingNotificationsPreferences";
    @Inject
    private NotificationPreferenceModelBridge notificationPreferenceModelBridge;
    @Inject
    private UnboundedEntityCacheManager cacheManager;
    @Inject
    private EntityReferenceFactory referenceFactory;
    private Map<EntityReference, List<NotificationPreference>> preferenceCache;
    private Map<EntityReference, Map<String, String>> eventGroupingStrategyCache;

    public void initialize() throws InitializationException {
        this.preferenceCache = this.cacheManager.createCache(CACHE_NAME, true);
        this.eventGroupingStrategyCache = this.cacheManager.createCache(EVENT_GROUPING_CACHE_NAME, true);
    }

    @Override
    public List<NotificationPreference> getNotificationsPreferences(DocumentReference userReference) throws NotificationException {
        if (userReference == null) {
            return Collections.emptyList();
        }
        List<NotificationPreference> preferences = this.preferenceCache.get(userReference);
        if (preferences != null) {
            return preferences;
        }
        preferences = this.notificationPreferenceModelBridge.getNotificationsPreferences(userReference);
        this.preferenceCache.put(this.referenceFactory.getReference((EntityReference)userReference), preferences);
        return preferences;
    }

    @Override
    public List<NotificationPreference> getNotificationsPreferences(WikiReference wikiReference) throws NotificationException {
        if (wikiReference == null) {
            return Collections.emptyList();
        }
        List<NotificationPreference> preferences = this.preferenceCache.get(wikiReference);
        if (preferences != null) {
            return preferences;
        }
        preferences = this.notificationPreferenceModelBridge.getNotificationsPreferences(wikiReference);
        this.preferenceCache.put(this.referenceFactory.getReference((EntityReference)wikiReference), preferences);
        return preferences;
    }

    @Override
    public void setStartDateForUser(DocumentReference userReference, Date startDate) throws NotificationException {
        this.notificationPreferenceModelBridge.setStartDateForUser(userReference, startDate);
    }

    @Override
    public void saveNotificationsPreferences(DocumentReference userReference, List<NotificationPreference> notificationPreferences) throws NotificationException {
        this.notificationPreferenceModelBridge.saveNotificationsPreferences(userReference, notificationPreferences);
    }

    public void invalidatePreference(EntityReference reference) {
        this.preferenceCache.remove(reference);
        this.eventGroupingStrategyCache.remove(reference);
    }

    @Override
    public String getEventGroupingStrategyHint(DocumentReference userDocReference, String target) throws NotificationException {
        Map strategyHints = this.eventGroupingStrategyCache.computeIfAbsent((EntityReference)userDocReference, reference -> new HashMap());
        if (!strategyHints.containsKey(target)) {
            String strategyHint = this.notificationPreferenceModelBridge.getEventGroupingStrategyHint(userDocReference, target);
            strategyHints.put(target, strategyHint);
        }
        return (String)strategyHints.get(target);
    }
}

