/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceCategory;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.text.StringUtils;

public abstract class AbstractNotificationPreference
implements NotificationPreference {
    protected boolean isNotificationEnabled;
    protected NotificationFormat format;
    protected Date startDate;
    protected Map<NotificationPreferenceProperty, Object> properties;
    protected String providerHint;
    protected NotificationPreferenceCategory category;

    public AbstractNotificationPreference(boolean isNotificationEnabled, NotificationFormat format, NotificationPreferenceCategory category, Date startDate, String providerHint, Map<NotificationPreferenceProperty, Object> properties) {
        this.isNotificationEnabled = isNotificationEnabled;
        this.format = format;
        this.category = category;
        this.startDate = startDate;
        this.providerHint = providerHint;
        this.properties = properties;
    }

    protected AbstractNotificationPreference() {
        this.isNotificationEnabled = true;
    }

    @Override
    public boolean isNotificationEnabled() {
        return this.isNotificationEnabled;
    }

    @Override
    public NotificationFormat getFormat() {
        return this.format;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Map<NotificationPreferenceProperty, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getProviderHint() {
        return this.providerHint == null || StringUtils.isBlank((CharSequence)this.providerHint) ? null : this.providerHint;
    }

    @Override
    public NotificationPreferenceCategory getCategory() {
        return this.category;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        AbstractNotificationPreference that = (AbstractNotificationPreference)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)that.format, (Object)this.format);
        equalsBuilder.append(that.properties, this.properties);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.format);
        hashCodeBuilder.append(this.properties);
        return hashCodeBuilder.hashCode();
    }
}

