/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReferenceResolver;

@Component(roles={LiveNotificationEmailEventFilter.class})
@Singleton
public class LiveNotificationEmailEventFilter {
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    private Logger logger;

    public boolean isEventFiltered(List<NotificationFilter> filters, Event event, DocumentReference user) throws NotificationException {
        Collection filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(user);
        for (NotificationFilter filter : filters) {
            NotificationFilter.FilterPolicy policy = filter.filterEvent(event, user, filterPreferences, NotificationFormat.EMAIL);
            switch (policy) {
                case FILTER: {
                    return true;
                }
                case KEEP: {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isCompositeEventHandled(DocumentReference user, CompositeEvent event) {
        return this.hasCorrespondingNotificationPreference(user, event) || this.isTriggeredByAFollowedUser(user, event);
    }

    public boolean canAccessEvent(DocumentReference user, CompositeEvent event) throws NotificationException {
        DocumentReference document = event.getDocument();
        return document == null || this.authorizationManager.hasAccess(Right.VIEW, user, (EntityReference)document) && this.isHiddenStatusHandled(user, event);
    }

    private boolean isHiddenStatusHandled(DocumentReference user, CompositeEvent event) throws NotificationException {
        if (event.getDocument() != null) {
            try {
                DocumentModelBridge document = this.documentAccessBridge.getTranslatedDocumentInstance(event.getDocument());
                return document.isHidden() == false || this.userPropertiesResolver.resolve(this.userReferenceResolver.resolve((Object)user, new Object[0]), new Object[0]).displayHiddenDocuments();
            }
            catch (Exception e) {
                throw new NotificationException(String.format("Error while loading [%s] to check if it is hidden.", event.getDocument()));
            }
        }
        return false;
    }

    private boolean hasCorrespondingNotificationPreference(DocumentReference user, CompositeEvent compositeEvent) {
        try {
            for (NotificationPreference notificationPreference : this.notificationPreferenceManager.getAllPreferences(user)) {
                if (!notificationPreference.getFormat().equals((Object)NotificationFormat.EMAIL) || !notificationPreference.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE) || !notificationPreference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE).equals(compositeEvent.getType())) continue;
                return notificationPreference.isNotificationEnabled();
            }
        }
        catch (NotificationException e) {
            this.logger.warn("Unable to retrieve the notifications preferences of [{}]: [{}]", (Object)user, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return false;
    }

    private boolean isTriggeredByAFollowedUser(DocumentReference user, CompositeEvent compositeEvent) {
        try {
            return this.notificationFilterPreferenceManager.getFilterPreferences(user).stream().anyMatch(fp -> this.isUserFilterPreference((NotificationFilterPreference)fp) && this.matchUser((NotificationFilterPreference)fp, compositeEvent));
        }
        catch (NotificationException e) {
            return false;
        }
    }

    private boolean isUserFilterPreference(NotificationFilterPreference filterPreference) {
        return this.matchFilter(filterPreference) && this.matchFormat(filterPreference, NotificationFormat.EMAIL) && this.matchFilterType(filterPreference, NotificationFilterType.INCLUSIVE) && this.matchAllEvents(filterPreference);
    }

    private boolean matchUser(NotificationFilterPreference filterPreference, CompositeEvent event) {
        return event.getUsers().contains(this.referenceResolver.resolve((Object)filterPreference.getUser(), new Object[0]));
    }

    private boolean matchFormat(NotificationFilterPreference filterPreference, NotificationFormat format) {
        return format == null || filterPreference.getNotificationFormats().contains(format);
    }

    private boolean matchFilter(NotificationFilterPreference pref) {
        return pref.isEnabled() && "eventUserNotificationFilter".equals(pref.getFilterName());
    }

    private boolean matchFilterType(NotificationFilterPreference pref, NotificationFilterType filterType) {
        return pref.getFilterType() == filterType;
    }

    private boolean matchAllEvents(NotificationFilterPreference filterPreference) {
        return filterPreference.getEventTypes().isEmpty();
    }
}

