/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.GroupingEventManager;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.notifiers.internal.email.AbstractMimeMessageIterator;
import org.xwiki.notifications.notifiers.internal.email.NotificationUserIterator;
import org.xwiki.notifications.notifiers.internal.email.PeriodicMimeMessageIterator;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.notifications.sources.internal.DefaultNotificationParametersFactory;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultPeriodicMimeMessageIterator
extends AbstractMimeMessageIterator
implements PeriodicMimeMessageIterator {
    @Inject
    private ParametrizedNotificationManager notificationManager;
    @Inject
    private DefaultNotificationParametersFactory notificationParametersFactory;
    @Inject
    private GroupingEventManager groupingEventManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    private Date lastTrigger;

    public void initialize(NotificationUserIterator userIterator, Map<String, Object> factoryParameters, Date lastTrigger, DocumentReference templateReference) {
        this.lastTrigger = lastTrigger;
        super.initialize((Iterator<DocumentReference>)userIterator, factoryParameters, (EntityReference)templateReference, userIterator.getInterval());
    }

    @Override
    protected List<CompositeEvent> retrieveCompositeEventList(DocumentReference user) throws NotificationException {
        NotificationParameters notificationParameters = new NotificationParameters();
        notificationParameters.user = user;
        notificationParameters.format = NotificationFormat.EMAIL;
        notificationParameters.expectedCount = 0x1FFFFFFF;
        notificationParameters.fromDate = this.lastTrigger;
        notificationParameters.endDateIncluded = false;
        this.notificationParametersFactory.useUserPreferences(notificationParameters);
        UserReference userReference = this.userReferenceResolver.resolve((Object)user, new Object[0]);
        List rawEvents = this.notificationManager.getRawEvents(notificationParameters);
        return this.groupingEventManager.getCompositeEvents(rawEvents, userReference, NotificationFormat.EMAIL.name());
    }
}

