/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.ExternalServletURLFactory;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.email.EmailTemplateRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class DefaultEmailTemplateRenderer
implements EmailTemplateRenderer {
    private static final String EVENT_BINDING_NAME = "event";
    private static final String USER_BINDING_NAME = "emailUser";
    @Inject
    @Named(value="xhtml/1.0")
    private BlockRenderer htmlBlockRenderer;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager executionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block executeTemplate(CompositeEvent event, String userId, Template template, Syntax syntax, Map<String, Object> customBindings) throws NotificationException {
        try {
            this.execution.pushContext(this.executionManager.clone(this.execution.getContext()));
        }
        catch (ExecutionContextException e) {
            throw new NotificationException("Failed to push a new execution context", (Throwable)e);
        }
        try {
            Block block = this.executeTemplateInContext(event, userId, template, syntax, customBindings);
            return block;
        }
        finally {
            this.execution.popContext();
        }
    }

    private Block executeTemplateInContext(CompositeEvent event, String userId, Template template, Syntax syntax, Map<String, Object> customBindings) throws NotificationException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        DocumentReference currentUser = context.getUserReference();
        XWikiURLFactory originalURLFactory = context.getURLFactory();
        ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
        try {
            context.setUserReference(template.getContent().getAuthorReference());
            scriptContext.setAttribute(EVENT_BINDING_NAME, event, 100);
            scriptContext.setAttribute(USER_BINDING_NAME, userId, 100);
            for (Map.Entry<String, Object> entry : customBindings.entrySet()) {
                scriptContext.setAttribute(entry.getKey(), entry.getValue(), 100);
            }
            context.setURLFactory((XWikiURLFactory)new ExternalServletURLFactory(context));
            if (this.renderingContext instanceof MutableRenderingContext) {
                ((MutableRenderingContext)this.renderingContext).push(null, null, syntax, null, false, syntax);
            }
            XDOM xDOM = this.templateManager.execute(template);
            return xDOM;
        }
        catch (Exception e) {
            throw new NotificationException("Failed to render the notification.", (Throwable)e);
        }
        finally {
            if (this.renderingContext instanceof MutableRenderingContext) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
            context.setURLFactory(originalURLFactory);
            scriptContext.removeAttribute(EVENT_BINDING_NAME, 100);
            scriptContext.removeAttribute(USER_BINDING_NAME, 100);
            for (String bindingName : customBindings.keySet()) {
                scriptContext.removeAttribute(bindingName, 100);
            }
            context.setUserReference(currentUser);
        }
    }

    public String renderHTML(Block block) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.htmlBlockRenderer.render(block, (WikiPrinter)printer);
        return printer.toString();
    }

    public String renderPlainText(Block block) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextBlockRenderer.render(block, (WikiPrinter)printer);
        return printer.toString();
    }
}

