/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.internal.DefaultEntityEvent;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.VoidMailListener;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.email.NotificationEmailGroupingStrategy;
import org.xwiki.notifications.notifiers.email.NotificationEmailRenderer;
import org.xwiki.notifications.notifiers.internal.email.EventsSorter;
import org.xwiki.notifications.notifiers.internal.email.LogoAttachmentExtractor;
import org.xwiki.notifications.notifiers.internal.email.MailTemplateImageAttachmentsExtractor;
import org.xwiki.notifications.notifiers.internal.email.UserAvatarAttachmentExtractor;
import org.xwiki.notifications.preferences.NotificationEmailInterval;
import org.xwiki.notifications.preferences.email.NotificationEmailUserPreferenceManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public abstract class AbstractMimeMessageIterator
implements Iterator<MimeMessage>,
Iterable<MimeMessage> {
    private static final String EVENTS = "events";
    private static final String HTML_EVENTS = "htmlEvents";
    private static final String PLAIN_TEXT_EVENTS = "plainTextEvents";
    private static final String SORTED_EVENTS = "sortedEvents";
    private static final String EMAIL_PROPERTY = "email";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String VELOCITY_VARIABLES = "velocityVariables";
    private static final String ERROR_MESSAGE = "Failed to generate an email for the user [{}].";
    private static final String ATTACHMENTS = "attachments";
    private static final String EMAIL_USER = "emailUser";
    private static final String MIMEMESSAGE_EXTRADATA_KEY = "notifications";
    @Inject
    protected Logger logger;
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="template")
    private MimeMessageFactory<MimeMessage> factory;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private NotificationEmailRenderer defaultNotificationEmailRenderer;
    @Inject
    private MailSenderConfiguration mailSenderConfiguration;
    @Inject
    private UserAvatarAttachmentExtractor userAvatarAttachmentExtractor;
    @Inject
    private LogoAttachmentExtractor logoAttachmentExtractor;
    @Inject
    private MailTemplateImageAttachmentsExtractor mailTemplateImageAttachmentsExtractor;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;
    @Inject
    private EventStore eventStore;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private NotificationEmailGroupingStrategy fallbackNotificationEmailGroupingStrategy;
    @Inject
    private NotificationEmailUserPreferenceManager notificationEmailUserPreferenceManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;
    private final MailListener listener = new VoidMailListener(){

        public void onPrepareMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
            AbstractMimeMessageIterator.this.onPrepare(message, true);
        }

        public void onPrepareMessageError(ExtendedMimeMessage message, Exception e, Map<String, Object> parameters) {
            AbstractMimeMessageIterator.this.onPrepare(message, false);
        }
    };
    private Iterator<DocumentReference> userIterator;
    private Map<String, Object> factoryParameters = new HashMap<String, Object>();
    private EntityReference templateReference;
    private Iterator<List<CompositeEvent>> processingEvents;
    private List<CompositeEvent> currentEvents = Collections.emptyList();
    private DocumentReference currentUser;
    private String currentUsedId;
    private InternetAddress currentUserEmail;
    private boolean hasNext;
    private NotificationEmailInterval interval;

    protected void initialize(Iterator<DocumentReference> userIterator, Map<String, Object> factoryParameters, EntityReference templateReference, NotificationEmailInterval interval) {
        this.userIterator = userIterator;
        this.factoryParameters = factoryParameters;
        this.templateReference = templateReference;
        this.interval = interval;
        this.computeNext();
    }

    private void onPrepare(ExtendedMimeMessage message, boolean delete) {
        List events = (List)message.getExtraData(MIMEMESSAGE_EXTRADATA_KEY);
        if (events != null && delete) {
            events.forEach(arg_0 -> ((EventStore)this.eventStore).deleteMailEntityEvent(arg_0));
        }
    }

    protected abstract List<CompositeEvent> retrieveCompositeEventList(DocumentReference var1) throws NotificationException;

    private NotificationEmailGroupingStrategy getEmailGroupingStrategy(DocumentReference userDocReference) {
        NotificationEmailGroupingStrategy strategy = this.fallbackNotificationEmailGroupingStrategy;
        UserReference userReference = this.documentReferenceUserReferenceResolver.resolve((Object)userDocReference, new Object[0]);
        String emailGroupingStrategyHint = this.notificationEmailUserPreferenceManager.getEmailGroupingStrategy(userReference, this.interval);
        if (this.componentManager.hasComponent(NotificationEmailGroupingStrategy.class, emailGroupingStrategyHint)) {
            try {
                strategy = (NotificationEmailGroupingStrategy)this.componentManager.getInstance(NotificationEmailGroupingStrategy.class, emailGroupingStrategyHint);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Error while loading NotificationEmailGroupingStrategy with hint [{}] for user [{}] and interval [{}]. Fallback on default strategy. Root cause: [{}]", new Object[]{emailGroupingStrategyHint, userReference, this.interval, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                this.logger.debug("Root cause of the error was: ", (Throwable)e);
            }
        } else {
            this.logger.warn("Cannot find a NotificationEmailGroupingStrategy with hint [{}] for user [{}] and interval [{}]. Fallback on default strategy.", new Object[]{emailGroupingStrategyHint, userReference, this.interval});
        }
        return strategy;
    }

    protected void computeNext() {
        if (this.processingEvents == null || !this.processingEvents.hasNext()) {
            this.currentEvents = Collections.emptyList();
            this.currentUserEmail = null;
            while ((this.currentEvents.isEmpty() || this.currentUserEmail == null) && this.userIterator.hasNext()) {
                this.currentUser = this.userIterator.next();
                try {
                    this.currentUserEmail = new InternetAddress(this.getUserEmail(this.currentUser));
                }
                catch (AddressException e) {
                    continue;
                }
                try {
                    List<CompositeEvent> compositeEvents = this.retrieveCompositeEventList(this.currentUser);
                    if (compositeEvents.isEmpty()) continue;
                    this.processingEvents = this.getEmailGroupingStrategy(this.currentUser).groupEventsPerMail(compositeEvents).iterator();
                    this.currentEvents = this.processingEvents.next();
                }
                catch (NotificationException e) {
                    this.logger.error(ERROR_MESSAGE, (Object)this.currentUser, (Object)e);
                }
            }
            this.currentUsedId = (String)this.serializer.serialize((EntityReference)this.currentUser, new Object[0]);
        } else {
            this.currentEvents = this.processingEvents.next();
        }
        this.hasNext = this.currentUserEmail != null && !this.currentEvents.isEmpty();
    }

    private void updateFactoryParameters(DocumentReference templateDocumentReference) throws NotificationException, AddressException {
        this.getAttachments().clear();
        this.handleEvents();
        this.handleWikiLogo();
        this.handleImageAttachmentsFromTemplate(templateDocumentReference);
        try {
            this.factoryParameters.put(FROM, new InternetAddress(this.mailSenderConfiguration.getFromAddress()));
        }
        catch (NullPointerException | AddressException e) {
            this.logger.warn("No default email address is configured in the administration.");
        }
        this.factoryParameters.put(TO, this.currentUserEmail);
    }

    private void handleImageAttachmentsFromTemplate(DocumentReference templateDocumentReference) throws NotificationException {
        Collection<Attachment> attachments = this.getAttachments();
        try {
            attachments.addAll(this.mailTemplateImageAttachmentsExtractor.getImages(templateDocumentReference));
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to get the attachments of the template [%s].", templateDocumentReference), (Throwable)e);
        }
    }

    private void handleEvents() throws NotificationException {
        ArrayList<String> htmlEvents = new ArrayList<String>();
        ArrayList<String> plainTextEvents = new ArrayList<String>();
        EventsSorter eventsSorter = new EventsSorter();
        for (CompositeEvent event : this.currentEvents) {
            String html = this.defaultNotificationEmailRenderer.renderHTML(event, this.currentUsedId);
            String plainText = this.defaultNotificationEmailRenderer.renderPlainText(event, this.currentUsedId);
            htmlEvents.add(html);
            plainTextEvents.add(plainText);
            eventsSorter.add(event, html, plainText);
        }
        Map<String, Object> velocityVariables = this.getVelocityVariables();
        velocityVariables.put(EMAIL_USER, this.currentUsedId);
        velocityVariables.put(EVENTS, this.currentEvents);
        velocityVariables.put(HTML_EVENTS, htmlEvents);
        velocityVariables.put(PLAIN_TEXT_EVENTS, plainTextEvents);
        velocityVariables.put(SORTED_EVENTS, eventsSorter.sort());
        this.handleAvatars();
    }

    private void handleWikiLogo() {
        try {
            this.getAttachments().add(this.logoAttachmentExtractor.getLogo());
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the logo.", (Throwable)e);
        }
    }

    private Collection<Attachment> getAttachments() {
        Object attachments = this.factoryParameters.get(ATTACHMENTS);
        if (attachments != null) {
            return (Collection)attachments;
        }
        ArrayList<Attachment> newList = new ArrayList<Attachment>();
        this.factoryParameters.put(ATTACHMENTS, newList);
        return newList;
    }

    private void handleAvatars() {
        HashSet userAvatars = new HashSet();
        for (CompositeEvent event : this.currentEvents) {
            userAvatars.addAll(event.getUsers());
        }
        Collection<Attachment> attachments = this.getAttachments();
        for (DocumentReference userAvatar : userAvatars) {
            try {
                attachments.add(this.userAvatarAttachmentExtractor.getUserAvatar(userAvatar, 32));
            }
            catch (Exception e) {
                this.logger.warn("Failed to add the avatar of [{}] in the email.", (Object)userAvatar, (Object)e);
            }
        }
    }

    private Map<String, Object> getVelocityVariables() {
        HashMap velocityVariables = this.factoryParameters.get(VELOCITY_VARIABLES);
        if (velocityVariables == null) {
            velocityVariables = new HashMap();
            this.factoryParameters.put(VELOCITY_VARIABLES, velocityVariables);
        }
        return velocityVariables;
    }

    private String getUserEmail(DocumentReference user) {
        return (String)this.documentAccessBridge.getProperty(user, new DocumentReference(user.getWikiReference().getName(), "XWiki", "XWikiUsers"), 0, EMAIL_PROPERTY);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MimeMessage next() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        WikiReference currentWiki = xcontext.getWikiReference();
        DocumentReference currentContextUser = xcontext.getUserReference();
        ExtendedMimeMessage message = null;
        try {
            xcontext.setWikiReference(this.currentUser.getWikiReference());
            xcontext.setUserReference(this.currentUser);
            DocumentReference templateDocumentReference = this.documentReferenceResolver.resolve((Object)this.templateReference, new Object[]{this.currentUser});
            this.updateFactoryParameters(templateDocumentReference);
            message = ExtendedMimeMessage.wrap((MimeMessage)((MimeMessage)this.factory.createMessage((Object)templateDocumentReference, this.factoryParameters)));
            message.setHeader("Auto-Submitted", "auto-generated");
            message.setHeader("X-Auto-Response-Suppress", "All");
            ArrayList events = new ArrayList();
            this.currentEvents.forEach(ce -> ce.getEvents().forEach(event -> events.add(new DefaultEntityEvent(event, this.currentUsedId))));
            message.addExtraData(MIMEMESSAGE_EXTRADATA_KEY, events);
        }
        catch (Exception e) {
            this.logger.error(ERROR_MESSAGE, (Object)this.currentUser, (Object)e);
        }
        finally {
            xcontext.setWikiReference(currentWiki);
            xcontext.setUserReference(currentContextUser);
        }
        this.computeNext();
        return message;
    }

    @Override
    public Iterator<MimeMessage> iterator() {
        return this;
    }

    public MailListener getMailListener() {
        return this.listener;
    }
}

