/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationDisplayer;
import org.xwiki.notifications.notifiers.internal.AbstractWikiNotificationRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.template.Template;

@Component(roles={WikiNotificationDisplayer.class})
public class WikiNotificationDisplayer
extends AbstractWikiNotificationRenderer
implements NotificationDisplayer {
    @Inject
    private NotificationDisplayer notificationDisplayer;
    private Template notificationTemplate;
    private List<String> supportedEvents;

    @Override
    public void initialize(BaseObject baseObject) throws NotificationException {
        super.initialize(baseObject);
        this.supportedEvents = List.of(this.eventType);
        this.notificationTemplate = this.extractTemplate(baseObject, "notificationTemplate");
    }

    public Block renderNotification(CompositeEvent eventNotification) throws NotificationException {
        Object oldContextAttribute = this.scriptContextManager.getCurrentScriptContext().getAttribute("event", 100);
        try {
            this.scriptContextManager.getCurrentScriptContext().setAttribute("event", eventNotification, 100);
            if (this.notificationTemplate == null) {
                Block block = this.notificationDisplayer.renderNotification(eventNotification);
                return block;
            }
            XDOM xDOM = this.templateManager.execute(this.notificationTemplate);
            return xDOM;
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to render notification template for the [%s].", this.eventType), (Throwable)e);
        }
        finally {
            this.scriptContextManager.getCurrentScriptContext().setAttribute("event", oldContextAttribute, 100);
        }
    }

    public List<String> getSupportedEvents() {
        return this.supportedEvents;
    }

    public Type getRoleType() {
        return NotificationDisplayer.class;
    }
}

