/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.eventstream.Event;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;
import org.xwiki.notifications.preferences.internal.cache.UnboundedEntityCacheManager;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component(roles={UserEventManager.class})
@Singleton
public class UserEventManager
implements Initializable {
    private static final String USERDATECACHE_NAME = "UserCreationDate";
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private Logger logger;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceFactory entityReferenceFactory;
    @Inject
    private UnboundedEntityCacheManager cacheManager;
    private Map<EntityReference, Date> userCreationDateCache;

    public void initialize() throws InitializationException {
        this.userCreationDateCache = this.cacheManager.createCache(USERDATECACHE_NAME, false);
    }

    public boolean isListening(Event event, DocumentReference user, NotificationFormat format) {
        try {
            if (this.hasAccess(user, event) && this.isEventAfterUserCreationDate(event, user) && (this.hasCorrespondingNotificationPreference(user, event, format) || this.isTriggeredByAFollowedUser(user, event, format))) {
                ArrayList<NotificationFilter> filters = new ArrayList<NotificationFilter>(this.notificationFilterManager.getAllFilters(user, true, NotificationFilter.FilteringPhase.PRE_FILTERING));
                filters.sort(null);
                return !this.isEventFiltered(filters, event, user, format);
            }
        }
        catch (NotificationException e) {
            this.logger.error("Failed to get event filters for user [{}]", (Object)user, (Object)e);
        }
        return false;
    }

    private boolean hasAccess(DocumentReference user, Event event) {
        DocumentReference document = event.getDocument();
        if (document != null) {
            return this.authorizationManager.hasAccess(Right.VIEW, user, (EntityReference)document);
        }
        SpaceReference space = event.getSpace();
        if (space != null) {
            return this.authorizationManager.hasAccess(Right.VIEW, user, (EntityReference)space);
        }
        WikiReference wiki = event.getWiki();
        if (wiki != null) {
            return this.authorizationManager.hasAccess(Right.VIEW, user, (EntityReference)wiki);
        }
        return true;
    }

    private boolean isEventAfterUserCreationDate(Event event, DocumentReference user) throws NotificationException {
        Date userCreationDate = this.getUserCreationDate(user);
        return event.getDate() == null || userCreationDate == null || !event.getDate().before(userCreationDate);
    }

    private Date getUserCreationDate(DocumentReference user) throws NotificationException {
        Date result;
        if (!this.userCreationDateCache.containsKey(user)) {
            try {
                result = this.documentAccessBridge.getDocumentInstance(user).getCreationDate();
                this.userCreationDateCache.put(this.entityReferenceFactory.getReference((EntityReference)user), result);
            }
            catch (Exception e) {
                throw new NotificationException(String.format("Cannot find creation date for user [%s].", user), (Throwable)e);
            }
        } else {
            result = this.userCreationDateCache.get(user);
        }
        return result;
    }

    private boolean hasCorrespondingNotificationPreference(DocumentReference user, Event event, NotificationFormat format) {
        try {
            List allPreferences = this.notificationPreferenceManager.getAllPreferences(user);
            for (NotificationPreference notificationPreference : allPreferences) {
                if (notificationPreference.getFormat() != format || !notificationPreference.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE) || !notificationPreference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE).equals(event.getType())) continue;
                return notificationPreference.isNotificationEnabled() && (notificationPreference.getStartDate() == null || event.getDate() == null || !event.getDate().before(notificationPreference.getStartDate()));
            }
            return allPreferences.isEmpty();
        }
        catch (NotificationException e) {
            this.logger.warn("Unable to retrieve the notifications preferences of [{}]: {}", (Object)user, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }

    private boolean isTriggeredByAFollowedUser(DocumentReference user, Event event, NotificationFormat format) {
        try {
            return this.notificationFilterPreferenceManager.getFilterPreferences(user).stream().anyMatch(fp -> this.isFilterCreatedBeforeEvent(event, (NotificationFilterPreference)fp) && this.isUserFilterPreference((NotificationFilterPreference)fp, format) && this.matchUser((NotificationFilterPreference)fp, event));
        }
        catch (NotificationException e) {
            return false;
        }
    }

    private boolean isFilterCreatedBeforeEvent(Event event, NotificationFilterPreference filterPreference) {
        return event.getDate() == null || filterPreference.getStartingDate() == null || !event.getDate().before(filterPreference.getStartingDate());
    }

    private boolean isUserFilterPreference(NotificationFilterPreference filterPreference, NotificationFormat format) {
        return this.matchFilter(filterPreference) && this.matchFormat(filterPreference, format) && this.matchFilterType(filterPreference, NotificationFilterType.INCLUSIVE) && this.matchAllEvents(filterPreference);
    }

    private boolean matchUser(NotificationFilterPreference filterPreference, Event event) {
        return event.getUser() != null && event.getUser().equals((Object)this.referenceResolver.resolve((Object)filterPreference.getUser(), new Object[0]));
    }

    private boolean matchFormat(NotificationFilterPreference filterPreference, NotificationFormat format) {
        return format == null || filterPreference.getNotificationFormats().contains(format);
    }

    private boolean matchFilter(NotificationFilterPreference pref) {
        return pref.isEnabled() && "eventUserNotificationFilter".equals(pref.getFilterName());
    }

    private boolean matchFilterType(NotificationFilterPreference pref, NotificationFilterType filterType) {
        return pref.getFilterType() == filterType;
    }

    private boolean matchAllEvents(NotificationFilterPreference filterPreference) {
        return filterPreference.getEventTypes().isEmpty();
    }

    private boolean isEventFiltered(List<NotificationFilter> filters, Event event, DocumentReference user, NotificationFormat format) throws NotificationException {
        Collection filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(user);
        for (NotificationFilter filter : filters) {
            NotificationFilter.FilterPolicy policy = filter.filterEvent(event, user, filterPreferences, format);
            switch (policy) {
                case FILTER: {
                    return true;
                }
                case KEEP: {
                    return false;
                }
            }
        }
        return false;
    }
}

