/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.notifications.notifiers.internal.UserEventDispatcher;

@Component(roles={UserEventDispatcherScheduler.class})
@Singleton
public class UserEventDispatcherScheduler
implements Disposable {
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private ExecutionContextManager contextManager;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    @Inject
    private UserEventDispatcher dispatcher;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean running;

    public void initialize() {
        this.scheduler.scheduleWithFixedDelay(this::run, 0L, 1L, TimeUnit.HOURS);
    }

    public void onEvent(Event event) {
        try {
            if (this.getSupportedEventTypes().contains(event.getType()) && !this.running) {
                this.scheduler.execute(this::run);
            }
        }
        catch (EventStreamException e) {
            this.logger.error("Failed to get supported event types", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.scheduler.shutdownNow();
    }

    private void run() {
        this.running = true;
        Thread currenthread = Thread.currentThread();
        currenthread.setPriority(4);
        currenthread.setName("User event dispatcher thread");
        try {
            this.contextManager.initialize(new ExecutionContext());
            this.dispatcher.flush();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            this.logger.error("Failed to pre-filter events", e);
        }
        finally {
            this.running = false;
            this.execution.removeContext();
        }
    }

    private Set<String> getSupportedEventTypes() throws EventStreamException {
        List descriptorList = this.recordableEventDescriptorManager.getRecordableEventDescriptors(true);
        return descriptorList.stream().map(RecordableEventDescriptor::getEventType).collect(Collectors.toSet());
    }
}

