/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventSearchResult;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.eventstream.internal.DefaultEntityEvent;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.eventstream.query.SortableEventQuery;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.internal.DeletedDocumentCleanUpFilterProcessingQueue;
import org.xwiki.notifications.notifiers.internal.UserEventManager;
import org.xwiki.observation.remote.RemoteObservationManagerConfiguration;
import org.xwiki.user.UserException;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.group.GroupException;
import org.xwiki.user.group.GroupManager;
import org.xwiki.user.internal.group.UsersCache;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={UserEventDispatcher.class})
@Singleton
public class UserEventDispatcher {
    private static final long BATCH_SIZE = 100L;
    @Inject
    private UsersCache userCache;
    @Inject
    private WikiDescriptorManager wikiManager;
    @Inject
    private UserEventManager userEventManager;
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    private ExecutionContextManager ecm;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private GroupManager groupManager;
    @Inject
    private UserManager userManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;
    @Inject
    private EventStore events;
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private RemoteObservationManagerConfiguration remoteObservation;
    @Inject
    private DeletedDocumentCleanUpFilterProcessingQueue cleanUpFilterProcessingQueue;
    @Inject
    private Logger logger;

    private Set<String> getSupportedEventTypes() throws EventStreamException {
        List descriptorList = this.recordableEventDescriptorManager.getRecordableEventDescriptors(true);
        return descriptorList.stream().map(RecordableEventDescriptor::getEventType).collect(Collectors.toSet());
    }

    public void flush() throws Exception {
        Set<String> types = this.getSupportedEventTypes();
        SimpleEventQuery query = new SimpleEventQuery();
        query.eq("preFiltered", (Object)false);
        query.open();
        query.eq("observationInstanceId", (Object)this.remoteObservation.getId());
        query.or();
        query.eq("observationInstanceId", null);
        query.close();
        query.addSort("date", SortableEventQuery.SortClause.Order.ASC);
        query.setLimit(100L);
        ArrayList<String> failedEvents = new ArrayList<String>();
        query.not().in("id", failedEvents);
        block8: while (true) {
            EventSearchResult result = this.events.search((EventQuery)query);
            try {
                if (result.getSize() == 0L) break;
                Iterable it = () -> result.stream().iterator();
                ArrayList completableFutures = new ArrayList((int)result.getSize());
                for (Event event : it) {
                    try {
                        completableFutures.add(this.prefilterEvent(event, types));
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to pre filter event with id [{}]: {}", (Object)event.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                        failedEvents.add(event.getId());
                    }
                }
                Iterator<Object> iterator = completableFutures.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block8;
                    CompletableFuture completableFuture = (CompletableFuture)iterator.next();
                    completableFuture.join();
                }
            }
            finally {
                if (result == null) continue;
                result.close();
                continue;
            }
            break;
        }
    }

    private CompletableFuture<?> prefilterEvent(Event event, Set<String> types) throws EventStreamException {
        if (types.contains(event.getType())) {
            return this.dispatch(event);
        }
        return this.events.prefilterEvent(event);
    }

    private CompletableFuture<?> dispatch(Event event) throws EventStreamException {
        try {
            this.ecm.pushContext(new ExecutionContext(), false);
        }
        catch (ExecutionContextException e) {
            throw new EventStreamException("Failed to push a new execution context", (Throwable)e);
        }
        try {
            CompletableFuture<?> completableFuture = this.dispatchInContext(event);
            return completableFuture;
        }
        finally {
            this.ecm.popContext();
        }
    }

    private CompletableFuture<?> dispatchInContext(Event event) {
        WikiReference eventWiki = event.getWiki();
        if (CollectionUtils.isNotEmpty((Collection)event.getTarget())) {
            boolean mailEnabled = this.notificationConfiguration.areEmailsEnabled();
            for (String entity : event.getTarget()) {
                DocumentReference entityReference = this.resolver.resolve((Object)entity, new Object[]{event.getWiki()});
                UserReference userReference = this.documentReferenceUserReferenceResolver.resolve((Object)entityReference, new Object[0]);
                try {
                    if (this.userManager.exists(userReference)) {
                        this.dispatch(event, entityReference, mailEnabled);
                        continue;
                    }
                    this.groupManager.getMembers(entityReference, true).forEach(userDocumentReference -> this.dispatch(event, (DocumentReference)userDocumentReference, mailEnabled));
                }
                catch (UserException e) {
                    this.logger.warn("Failed to verify if user [{}] exists. Cause: [{}]", (Object)userReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                catch (GroupException e) {
                    this.logger.warn("Failed to get the member of the entity [{}]: {}", (Object)entity, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
        } else {
            this.dispatch(event, this.userCache.getUsers(eventWiki, true));
            if (!this.wikiManager.isMainWiki(eventWiki.getName())) {
                List userList = this.userCache.getUsers(new WikiReference(this.wikiManager.getMainWikiId()), true);
                this.dispatch(event, userList);
            }
        }
        return this.events.prefilterEvent(event);
    }

    private void dispatch(Event event, DocumentReference user, boolean mailEnabled) {
        String entityId = (String)this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]);
        if (this.userEventManager.isListening(event, user, NotificationFormat.ALERT) && !this.isStatusPrefiltered(event, entityId)) {
            this.saveEventStatus(event, entityId);
        }
        if (mailEnabled && this.userEventManager.isListening(event, user, NotificationFormat.EMAIL)) {
            this.saveMailEntityEvent(event, entityId);
        }
        if (Strings.CS.equals(event.getType(), "delete")) {
            this.cleanUpFilterProcessingQueue.addCleanUpTask(user, event.getDocument());
        }
    }

    private boolean isStatusPrefiltered(Event event, String entityId) {
        boolean bl;
        block8: {
            SimpleEventQuery eventQuery = new SimpleEventQuery(0L, 0L);
            eventQuery.eq("id", (Object)event.getId());
            eventQuery.withStatus(entityId);
            EventSearchResult result = this.events.search((EventQuery)eventQuery);
            try {
                boolean bl2 = bl = result.getTotalHits() > 0L;
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error("Failed to check status for event [{}] and entity [{}]", new Object[]{event.getId(), entityId, e});
                    return false;
                }
            }
            result.close();
        }
        return bl;
    }

    private void dispatch(Event event, List<DocumentReference> users) {
        boolean mailEnabled = this.notificationConfiguration.areEmailsEnabled();
        for (DocumentReference user : users) {
            this.dispatch(event, user, mailEnabled);
        }
    }

    private void saveEventStatus(Event event, String entityId) {
        this.events.saveEventStatus((EventStatus)new DefaultEventStatus(event, entityId, false));
    }

    private void saveMailEntityEvent(Event event, String entityId) {
        this.events.saveMailEntityEvent((EntityEvent)new DefaultEntityEvent(event, entityId));
    }
}

