/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationException;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;
import org.xwiki.text.StringUtils;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractWikiNotificationRenderer
implements WikiComponent {
    protected static final String EVENT_BINDING_NAME = "event";
    @Inject
    protected TemplateManager templateManager;
    @Inject
    protected ScriptContextManager scriptContextManager;
    @Inject
    protected EntityReferenceSerializer<String> referenceSerializer;
    protected BaseObjectReference objectReference;
    protected DocumentReference authorReference;
    protected String eventType;

    public void initialize(BaseObject baseObject) throws NotificationException {
        this.objectReference = (BaseObjectReference)baseObject.getReference();
        this.authorReference = baseObject.getOwnerDocument().getAuthorReference();
        this.eventType = this.extractProperty(baseObject, "eventType");
    }

    protected Template extractTemplate(BaseObject baseObject, String propertyName) throws NotificationException {
        try {
            String xObjectTemplate;
            BaseProperty property = (BaseProperty)baseObject.get(propertyName);
            if (property != null && property.getValue() != null && StringUtils.isNotBlank((CharSequence)(xObjectTemplate = property.getValue().toString()))) {
                return this.templateManager.createStringTemplate((String)this.referenceSerializer.serialize(property.getReference(), new Object[0]), xObjectTemplate, this.getAuthorReference(), baseObject.getDocumentReference());
            }
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to render the template provided in the base object [%s]", baseObject), (Throwable)e);
        }
        return null;
    }

    protected String extractProperty(BaseObject baseObject, String propertyName) throws NotificationException {
        try {
            return baseObject.getStringValue(propertyName);
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to extract the parameter [%s] from the [%s] NotificationDisplayerClass.", propertyName, baseObject), (Throwable)e);
        }
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.objectReference.getParent();
    }

    public EntityReference getEntityReference() {
        return this.objectReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public String getRoleHint() {
        return this.eventType;
    }

    public WikiComponentScope getScope() {
        return WikiComponentScope.WIKI;
    }
}

