/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.script;

import com.rometools.rome.io.SyndFeedOutput;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.JobException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationRenderer;
import org.xwiki.notifications.notifiers.internal.DefaultAsyncNotificationRenderer;
import org.xwiki.notifications.notifiers.internal.NotificationAsyncRendererConfiguration;
import org.xwiki.notifications.notifiers.rss.NotificationRSSManager;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.notifications.sources.internal.DefaultNotificationParametersFactory;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.AsyncRendererExecutor;
import org.xwiki.rendering.async.internal.AsyncRendererExecutorResponse;
import org.xwiki.rendering.async.internal.AsyncRendererResult;
import org.xwiki.rendering.block.Block;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="notification.notifiers")
@Singleton
public class NotificationNotifiersScriptService
implements ScriptService {
    @Inject
    private NotificationRenderer notificationRenderer;
    @Inject
    private NotificationRSSManager notificationRSSManager;
    @Inject
    private ParametrizedNotificationManager notificationManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private AsyncRendererExecutor asyncRendererExecutor;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private DefaultNotificationParametersFactory parametersFactory;

    public Block render(CompositeEvent event) throws NotificationException {
        return this.notificationRenderer.render(event);
    }

    public String getFeed(int entryNumber) throws NotificationException {
        String userId = (String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]);
        return this.getFeed(userId, entryNumber);
    }

    public String getFeed(String userId, int entryNumber) throws NotificationException {
        SyndFeedOutput output = new SyndFeedOutput();
        NotificationParameters parametersForUserAndCount = this.parametersFactory.getParametersForUserAndCount(userId, entryNumber);
        List events = this.notificationManager.getEvents(parametersForUserAndCount);
        try {
            return output.outputString(this.notificationRSSManager.renderFeed(events));
        }
        catch (Exception e) {
            throw new NotificationException("Unable to render RSS feed", (Throwable)e);
        }
    }

    private String computeAsyncPlaceholder(AsyncRendererExecutorResponse response, boolean inline) {
        String commonPart = String.format("class=\"xwiki-async\" data-xwiki-async-id=\"%s\" data-xwiki-async-client-id=\"%s\"", response.getJobIdHTTPPath(), response.getAsyncClientId());
        String result = inline ? String.format("<span %s></span>", commonPart) : String.format("<div %s></div>", commonPart);
        return result;
    }

    public String getNotificationCount(NotificationParameters parameters, boolean forcePlaceHolder) throws NotificationException {
        NotificationAsyncRendererConfiguration configuration = new NotificationAsyncRendererConfiguration(parameters, true);
        configuration.setPlaceHolderForced(forcePlaceHolder);
        return this.getAsyncNotification(configuration);
    }

    public String getNotifications(NotificationParameters parameters, boolean forcePlaceHolder) throws NotificationException {
        NotificationAsyncRendererConfiguration configuration = new NotificationAsyncRendererConfiguration(parameters, false);
        configuration.setPlaceHolderForced(forcePlaceHolder);
        return this.getAsyncNotification(configuration);
    }

    private String getAsyncNotification(NotificationAsyncRendererConfiguration configuration) throws NotificationException {
        this.verifyParameterMaxCount(configuration.getNotificationParameters());
        try {
            DefaultAsyncNotificationRenderer asyncNotificationRenderer = (DefaultAsyncNotificationRenderer)((ComponentManager)this.componentManager.get()).getInstance(DefaultAsyncNotificationRenderer.class);
            asyncNotificationRenderer.initialize(configuration);
            AsyncRendererExecutorResponse response = this.asyncRendererExecutor.render((AsyncRenderer)asyncNotificationRenderer, (AsyncRendererConfiguration)configuration);
            AsyncRendererResult result = response.getStatus().getResult();
            if (result != null && !configuration.isPlaceHolderForced()) {
                return result.getResult();
            }
            return this.computeAsyncPlaceholder(response, configuration.isCount());
        }
        catch (ComponentLookupException | JobException | RenderingException e) {
            throw new NotificationException("Unable to retrieve notifications", e);
        }
    }

    private void verifyParameterMaxCount(NotificationParameters parameters) {
        if (parameters.expectedCount == -1) {
            parameters.expectedCount = 20;
        }
    }
}

